/**********************************************
 * StairwayToSQLCLR-06_TestQueries-03.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 6: Development Tools
 * http://www.sqlservercentral.com/articles/SQLCLR/
 * 
 * Copyright (C) 2016 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO
------------------------------
-- IGNORE THIS SECTION
IF (OBJECT_ID(N'tempdb..#F5') IS NULL)
BEGIN
	CREATE TABLE #F5 (Col1 INT);
END;
SET NOEXEC ON;
GO
-- IGNORE THIS SECTION
------------------------------

USE [StairwayToSQLCLR-06_ConnectionTypeTest];


SELECT SQLCLR.StairwayToSQLCLR_ConnectionTest(N'SELECT @@SERVERNAME + N'' : '' + ORIGINAL_LOGIN() + N'' : '' + SESSION_USER;', 0);
/*
Msg 313, Level 16, State 2, Line 30
An insufficient number of arguments were supplied for the procedure or function dbo.StairwayToSQLCLR_ConnectionTest.
*/

SELECT SQLCLR.StairwayToSQLCLR_ConnectionTest(N'SELECT @@SERVERNAME + N'' : '' + ORIGINAL_LOGIN() + N'' : '' + SESSION_USER;', '', 0);
-- Still works as expected.

------------------------------------------------
-- Try some operations that we might not be sure of

SELECT SQLCLR.StairwayToSQLCLR_ConnectionTest(N'SELECT @@SERVERNAME + N'' : '' + ORIGINAL_LOGIN() + N'' : '' + SESSION_USER;', '', 1);
/*
Msg 6522, Level 16, State 1, Line 1
A .NET Framework error occurred during execution of user-defined routine or aggregate "StairwayToSQLCLR_ConnectionTest": 
System.InvalidOperationException: Data access is not allowed in an impersonated context. 
*/
-- This error is expected as it is what we received in the last series of tests.

SELECT SQLCLR.StairwayToSQLCLR_ConnectionTest(N'SELECT @@SERVERNAME + N'' : '' + ORIGINAL_LOGIN() + N'' : '' + SESSION_USER;',
                                              N'Server=(localdb)\.',
                                              0);
/*
Msg 6522, Level 16, State 1, Line 53
A .NET Framework error occurred during execution of user-defined routine or aggregate "StairwayToSQLCLR_ConnectionTest": 
System.Security.SecurityException: Request failed.
System.Security.SecurityException: 
   at System.Security.CodeAccessSecurityEngine.Check(Object demand, StackCrawlMark& stackMark, Boolean isPermSet)
   at System.Security.PermissionSet.Demand()
   at System.Data.LocalDBAPI.DemandLocalDBPermissions()
*/
-- This error is due to a "bug" in the SQLCLR environment that prohibits using the new "(localdb)\{instance_name}"
-- syntax by default, most likely because the LocalDB API starts an external process (i.e. SQL Server Express
-- LocalDB) if it is not already started. While this syntax actually does work if the Assembly is marked as UNSAFE,
-- there is an App Domain setting that can be enabled to allow this syntax to work when the Assembly is marked as
-- EXTERNAL_ACCESS. Unfortunately, setting that option requires that the Assembly be marked as UNSAFE. The "bug" is
-- that this App Domain option is supposed to be enabled by default. I submitted a Connect item to fix this. But
-- for now, if we want to connect to a LocalDB instance from within SQLCLR, and without marking the Assembly as
-- UNSAFE, then we need to use named-pipes.
GO

SELECT dbo.GetLocalServerNameForConnectionString(N'Server={{ServerName}}') AS [ConnectionString];

SELECT SQLCLR.StairwayToSQLCLR_ConnectionTest(N'SELECT @@SERVERNAME + N'' :: '' + ORIGINAL_LOGIN() + N'' :: '' + SESSION_USER;',
                           dbo.GetLocalServerNameForConnectionString(N'Server={{ServerName}}; Trusted_Connection=true;'),
                           0);


SELECT SQLCLR.StairwayToSQLCLR_ConnectionTest(N'SELECT @@SERVERNAME + N'' :: '' + ORIGINAL_LOGIN() + N'' :: '' + SESSION_USER;',
                           dbo.GetLocalServerNameForConnectionString(N'Server={{ServerName}}; Trusted_Connection=true;'),
                           1);
-- no difference when running LocalDB since it is a background process, not a service, and runs
-- as the Windows Login that stared it. Running on any other edition would show a difference in
-- most cases.

---------

-- Does NULL for @SqlToExecute cause an error:
SELECT SQLCLR.StairwayToSQLCLR_ConnectionTest(NULL,
                           dbo.GetLocalServerNameForConnectionString(N'Server={{ServerName}}; Trusted_Connection=true;'),
                           0);
GO


-- What about NULL for @ConnectionString:
SELECT SQLCLR.StairwayToSQLCLR_ConnectionTest(N'SELECT GETDATE();',
                           NULL,
                           0);
GO


-- What about DEFAULT values:
SELECT SQLCLR.StairwayToSQLCLR_ConnectionTest(N'SELECT GETDATE();',
                           DEFAULT,
                           DEFAULT);
GO


-- What about EXEC values:
DECLARE @Return SQL_VARIANT;
EXEC @Return = SQLCLR.StairwayToSQLCLR_ConnectionTest N'SELECT GETDATE();';
SELECT @Return;
GO

---------

-- Create a table
SELECT SQLCLR.StairwayToSQLCLR_ConnectionTest(N'CREATE TABLE #Test(Col1 INT); SELECT OBJECT_ID(N''tempdb..#Test'');',
                           dbo.GetLocalServerNameForConnectionString(N'Server={{ServerName}}; Trusted_Connection=true;'),
                           0);
GO


-- Call NEWID() and SET
SELECT SQLCLR.StairwayToSQLCLR_ConnectionTest(N'SET NOCOUNT ON; SELECT NEWID();',
                           dbo.GetLocalServerNameForConnectionString(N'Server={{ServerName}}; Trusted_Connection=true;'),
                           0);
GO

---------

IF (OBJECT_ID(N'dbo.TransactionTest') IS NULL)
BEGIN
    PRINT 'Creating dbo.TransactionTest table...';
    CREATE TABLE dbo.TransactionTest
    (
      TransactionTestID INT NOT NULL IDENTITY(1, 1) CONSTRAINT [PK_TransactionTest] PRIMARY KEY,
      [Value] NVARCHAR(50) NULL,
	 InsertTime DATETIME NOT NULL CONSTRAINT [DF_TransactionTest_InsertTime] DEFAULT (GETDATE())
    );
END;

-- run once, just to get some data in the table:
INSERT INTO dbo.TransactionTest ([Value]) VALUES (N'first!');
SELECT * FROM dbo.TransactionTest;

-- run through the "GO". Let's see if the remotely-executed INSERT is Rolled-back:
BEGIN TRY
    BEGIN TRAN

    INSERT INTO dbo.TransactionTest ([Value]) VALUES (N'before call to StairwayToSQLCLR_ConnectionTest...');

    SELECT SQLCLR.StairwayToSQLCLR_ConnectionTest(N'INSERT INTO dbo.TransactionTest ([Value]) VALUES (NEWID());',
                           dbo.GetLocalServerNameForConnectionString(N'Server={{ServerName}}; Trusted_Connection=true;'),
                           0);

    INSERT INTO dbo.TransactionTest ([Value]) VALUES (N'after call to StairwayToSQLCLR_ConnectionTest...');

    SELECT * FROM dbo.TransactionTest;

    ROLLBACK TRAN;
END TRY
BEGIN CATCH
    IF (@@TRANCOUNT > 0)
    BEGIN
        ROLLBACK TRAN;
    END;

    DECLARE @Error NVARCHAR(4000);
    SET @Error = ERROR_MESSAGE();
    RAISERROR(@Error, 16, 1);
    RETURN;
END CATCH;
/*
Msg 50000, Level 16, State 1, Line 164
A .NET Framework error occurred during execution of user-defined routine or aggregate "StairwayToSQLCLR_ConnectionTest": 
System.Data.SqlClient.SqlException: MSDTC on server 'DALI\LOCALDB#SH666D8E' is unavailable.
*/
-- MSDTC = Microsoft Distributed Transaction Coordinator. Hence, it is attempting to bind the remote DML statement to
-- the current transaction.
GO


-- Run through the "GO" again. But this time, we added "Enlist=false" to the ConnectionString:
-- First, check the table:
SELECT * FROM dbo.TransactionTest;

BEGIN TRY
    BEGIN TRAN

    INSERT INTO dbo.TransactionTest ([Value]) VALUES (N'before call to StairwayToSQLCLR_ConnectionTest...');

    SELECT SQLCLR.StairwayToSQLCLR_ConnectionTest(
                 N'INSERT INTO [StairwayToSQLCLR-06_ConnectionTypeTest].dbo.TransactionTest ([Value]) VALUES (NEWID());',
                           dbo.GetLocalServerNameForConnectionString(N'Server={{ServerName}}; Trusted_Connection=true; Enlist=false;'),
                           0);

    INSERT INTO dbo.TransactionTest ([Value]) VALUES (N'after call to StairwayToSQLCLR_ConnectionTest...');

    SELECT * FROM dbo.TransactionTest;

    ROLLBACK TRAN;
END TRY
BEGIN CATCH
    IF (@@TRANCOUNT > 0)
    BEGIN
        ROLLBACK TRAN;
    END;

    DECLARE @Error NVARCHAR(4000);
    SET @Error = ERROR_MESSAGE();
    RAISERROR(@Error, 16, 1);
    RETURN;
END CATCH;

SELECT * FROM dbo.TransactionTest;
-- The two statements run natively here were rolled-back, but the remote DML statement
-- did not get rolled-back. If MSDTC was running, the remote DML statement would also
-- get rolled-back.

GO

------------------------------
-- IGNORE THIS SECTION
GO
SET NOEXEC OFF;
IF (OBJECT_ID(N'tempdb..#F5') IS NOT NULL)
BEGIN
	RAISERROR(N'	Please do not hit F5 / Control-E / "! Execute" button for this script.
	Please highlight and run each section separately.', 16, 1);
	DROP TABLE #F5;
END;
GO
-- IGNORE THIS SECTION
------------------------------
