using System; // DBNull
using System.Data.SqlClient; // SqlConnection & SqlCommand
using System.Data.SqlTypes; // SqlString & SqlBoolean
using System.Security.Principal; // WindowsImpersonationContext
using Microsoft.SqlServer.Server; // SqlFunction, DataAccessKind, & SqlContext

public class Testing
{
    // Check ALTER FUNCTION statement in "PostDeploy-SetFunctionOptions.sql"
    [SqlFunction(Name = "StairwayToSQLCLR_ConnectionTest",
        DataAccess = DataAccessKind.Read,
        SystemDataAccess = SystemDataAccessKind.Read)]
    public static object ConnectionTypeTest(SqlString SqlToExecute,
        [SqlFacet(MaxSize = 300)] SqlString Connection, // added for Issue #4
        SqlBoolean UseImpersonation)
    {
        object _Output = DBNull.Value;
        WindowsImpersonationContext _ImpersonationContext = null;

        // added for Issue #4 : BEGIN
        string _ConnectionString = Connection.Value.Trim();
        if (_ConnectionString == String.Empty)
        {
            _ConnectionString = "Context Connection = true;"; // default
        }
        // added for Issue #4 : END

        try
        {
            using (SqlConnection _Connection =
                new SqlConnection(_ConnectionString)) // changed for Issue #4
            {
                using (SqlCommand _Command = _Connection.CreateCommand())
                {
                    _Command.CommandText = SqlToExecute.Value;

                    if (UseImpersonation.IsTrue)
                    {
                        _ImpersonationContext =
                            SqlContext.WindowsIdentity.Impersonate();
                    }
                    _Connection.Open();
                    if (_ImpersonationContext != null)
                    {
                        _ImpersonationContext.Undo();
                    }

                    _Output = _Command.ExecuteScalar();
                }
            }
        }
        finally
        {
            if (_ImpersonationContext != null)
            {
                _ImpersonationContext.Undo();
                _ImpersonationContext.Dispose();
            }
        }

        return _Output;
    }
}

