/**********************************************
 * StairwayToSQLCLR-06_TestQueries-02.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 6: Development Tools
 * http://www.sqlservercentral.com/articles/SQLCLR/
 * 
 * Copyright (C) 2016 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO
------------------------------
-- IGNORE THIS SECTION
IF (OBJECT_ID(N'tempdb..#F5') IS NULL)
BEGIN
	CREATE TABLE #F5 (Col1 INT);
END;
SET NOEXEC ON;
GO
-- IGNORE THIS SECTION
------------------------------

USE [StairwayToSQLCLR-06_ConnectionTypeTest];

SELECT assembly_id, name, clr_name FROM sys.assemblies WHERE assembly_id <> 1;
-- We now have values for "version" and "publickeytoken". But the "version" numbers
-- are the ones that we set for the first field ("Assembly version"), not the second
-- one ("File version"). The only other thing to change was that we signed the
-- Assembly. It looks like we just found a bug ;-).
   
SELECT * FROM sys.assembly_files WHERE assembly_id <> 1;
-- Only 1 file this time. Entry with "file_id = 2" is no longer present. This is due
-- to unchecking "Include Symbols"


------------------------------------------------
-- Try some operations that we might not be sure of

SELECT dbo.StairwayToSQLCLR_ConnectionTest(N'SELECT GETDATE();', 0);
-- Still works as expected.

SELECT dbo.StairwayToSQLCLR_ConnectionTest(N'SELECT GETDATE();', 1);
/*
Msg 6522, Level 16, State 1, Line 1
A .NET Framework error occurred during execution of user-defined routine or aggregate "StairwayToSQLCLR_ConnectionTest": 
System.InvalidOperationException: Data access is not allowed in an impersonated context. 
*/
-- The in-process Context Connection does not allow for Impersonation. It would be nice to confirm
-- that Impersonation does work, but that requires and external / regular connection. We can go
-- back and add an input parameter for ConnectionString to allow us to test that and other things.


SELECT dbo.StairwayToSQLCLR_ConnectionTest(N'SELECT ORIGINAL_LOGIN() + N'' : '' +SESSION_USER;', 0);

------------------------------
-- IGNORE THIS SECTION
GO
SET NOEXEC OFF;
IF (OBJECT_ID(N'tempdb..#F5') IS NOT NULL)
BEGIN
	RAISERROR(N'	Please do not hit F5 / Control-E / "! Execute" button for this script.
	Please highlight and run each section separately.', 16, 1);
	DROP TABLE #F5;
END;
GO
-- IGNORE THIS SECTION
------------------------------
