using System; // DBNull
using System.Data.SqlClient; // SqlConnection & SqlCommand
using System.Data.SqlTypes; // SqlString & SqlBoolean
using System.Security.Principal; // WindowsImpersonationContext
using Microsoft.SqlServer.Server; // SqlFunction, DataAccessKind, & SqlContext

public class Testing
{
    [SqlFunction(Name = "StairwayToSQLCLR_ConnectionTest",
        DataAccess = DataAccessKind.Read,
        SystemDataAccess = SystemDataAccessKind.Read)]
    public static object ConnectionTypeTest(SqlString SqlToExecute,
        SqlBoolean UseImpersonation)
    {
        object _Output = DBNull.Value;
        WindowsImpersonationContext _ImpersonationContext = null;

        try
        {
            using (SqlConnection _Connection =
                new SqlConnection("Context Connection = true;"))
            {
                using (SqlCommand _Command = _Connection.CreateCommand())
                {
                    _Command.CommandText = SqlToExecute.Value;

                    if (UseImpersonation.IsTrue)
                    {
                        _ImpersonationContext =
                            SqlContext.WindowsIdentity.Impersonate();
                    }
                    _Connection.Open();
                    if (_ImpersonationContext != null)
                    {
                        _ImpersonationContext.Undo();
                    }

                    _Output = _Command.ExecuteScalar();
                }
            }
        }
        finally
        {
            if (_ImpersonationContext != null)
            {
                _ImpersonationContext.Undo();
                _ImpersonationContext.Dispose();
            }
        }

        return _Output;
    }
}

