/**********************************************
 * StairwayToSQLCLR-05-06-RemoveExampleDBandLogins.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 5: Development (Using .NET within SQL Server)
 * http://www.sqlservercentral.com/articles/SQLCLR/119429/
 * 
 * Copyright (C) 2015 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

USE [master];
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO

BEGIN TRY

	IF (DB_ID(N'StairwayToSQLCLR') IS NOT NULL)
	BEGIN
		PRINT 'Setting [StairwayToSQLCLR] test DB to SINGLE_USER mode...';
		ALTER DATABASE [StairwayToSQLCLR]
			SET SINGLE_USER
			WITH ROLLBACK IMMEDIATE;

		PRINT 'Dropping [StairwayToSQLCLR] test DB...';
		DROP DATABASE [StairwayToSQLCLR];

		PRINT 'Sample Database removed!';
	END;
	ELSE
	BEGIN
		PRINT '[StairwayToSQLCLR] test DB has already been removed.';
	END;

	PRINT '--------------------';
	------------------------------

	IF (EXISTS (
				SELECT	*
				FROM	[master].sys.server_principals sp
				WHERE	sp.name = N'MrStairwayToSQLCLR'
			)
		)
	BEGIN
		PRINT 'Dropping test SQL Server Login [MrStairwayToSQLCLR] ...';
		DROP LOGIN [MrStairwayToSQLCLR];
	END;
	ELSE
	BEGIN
		PRINT '[MrStairwayToSQLCLR] test Login has already been removed.';
	END;

	PRINT '--------------------';
	------------------------------

	IF (EXISTS (
				SELECT	*
				FROM	[master].sys.asymmetric_keys ak
				WHERE	ak.name = N'StairwayToSQLCLR-04-Key1'
			)
		)
	BEGIN
		PRINT 'Dropping test Asymmetric Key [StairwayToSQLCLR-04-Key1] ...';
		DROP ASYMMETRIC KEY [StairwayToSQLCLR-04-Key1];
	END;
	ELSE
	BEGIN
		PRINT '[StairwayToSQLCLR-04-Key1] test Asymmetric Key has already been removed.';
	END;

	PRINT '--------------------';
	------------------------------

END TRY
BEGIN CATCH

	DECLARE @Message NVARCHAR(4000);
	SET @Message = ERROR_MESSAGE();

	RAISERROR(@Message, 16, 1);

END CATCH;
GO
