/**********************************************
 * StairwayToSQLCLR-05-04-FrameworkVersionTest.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 5: Development (Using .NET within SQL Server)
 * http://www.sqlservercentral.com/articles/SQLCLR/119429/
 * 
 * Copyright (C) 2015 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/
 
USE [StairwayToSQLCLR];
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO

BEGIN TRY

	IF (OBJECT_ID(N'dbo.GZip') IS NOT NULL)
	BEGIN
		PRINT N'Dropping Scalar Function [GZip] ...';
		DROP FUNCTION [dbo].[GZip];
		PRINT 'Done.';
		PRINT '';
	END;

	IF (ASSEMBLYPROPERTY(N'StairwayToSQLCLR-05_FrameworkVersionTest', 'SimpleName') IS NOT NULL)
	BEGIN
		PRINT 'Dropping Assembly [StairwayToSQLCLR-05_FrameworkVersionTest] ...';
		DROP ASSEMBLY [StairwayToSQLCLR-05_FrameworkVersionTest];
		PRINT 'Done.';
		PRINT '';
	END;


	PRINT 'Creating Assembly [StairwayToSQLCLR-05_FrameworkVersionTest] ...';
	CREATE ASSEMBLY [StairwayToSQLCLR-05_FrameworkVersionTest]
		AUTHORIZATION [dbo]
		FROM 0x4D5A90000300000004000000FFFF0000B800000000000000400000000000000000000000000000000000000000000000000000000000000000000000800000000E1FBA0E00B409CD21B8014CCD21546869732070726F6772616D2063616E6E6F742062652072756E20696E20444F53206D6F64652E0D0D0A2400000000000000504500004C010300F1EBC7540000000000000000E00002210B010B00000C00000008000000000000BE2B00000020000000400000000000100020000000020000040000000000000004000000000000000080000000020000B5060100030040850000100000100000000010000010000000000000100000000000000000000000682B000053000000004000005004000000000000000000000000000000000000006000000C000000302A00001C0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000200000080000000000000000000000082000004800000000000000000000002E74657874000000C40B000000200000000C000000020000000000000000000000000000200000602E72737263000000500400000040000000060000000E0000000000000000000000000000400000402E72656C6F6300000C0000000060000000020000001400000000000000000000000000004000004\
200000000000000000000000000000000A02B0000000000004800000002000500E02100005008000009000000000000000000000000000000502000000001000000000000000000000000000000000000000000000000000000000000000000009DCF20D0A0AB08A9FEA8D32958F09328A3B0C36857F75CB714B39392382DBE501C21DF7BDFF9E7A2FA7E421F6A535F7D464EE44E5BCCDEA1CEDB2BF551CD8E16B90D980875032E3CF9955BECF40402E0EE64392074CDD6F6C891781390454BB2736D4B719414756E7B7C2F7DADB79BABB830F317CF0A0FD4FBBBAA217FCC3647E743BD859A21D80E7122B6CFE451CFD4AF11D011C993EF509EED68D884176B79645C46FF44E0CA75A7FD75A129E829111D8D01CE059F95E73CD17ED1564A0ECAC2BD9BB5583697DFFA00360F806427F1F2CB37CD3CEA1496EAD204B83C668F042A27FC0DAE45757CF724C57F67007C900F262FCD5FE27512E3899EA74B99B4651B3004006000000001000011026F0F00000A2D0A026F1000000A166A3306281100000A2A731200000A0B0717731300000A0C08026F1400000A16026F1000000A696F1500000ADE0A082C06086F1600000ADC076F1700000A731800000A0ADE0A072C06076F1600000ADC062A011C000002002600163C000A0000000002001E003654000A000000001E02281900000A2A42534A4201000\
100000000000C00000076322E302E35303732370000000005006C00000040020000237E0000AC0200004003000023537472696E677300000000EC0500000800000023555300F4050000100000002347554944000000040600004C02000023426C6F620000000000000002000001471502000900000000FA2533001600000100000016000000020000000200000001000000190000000C00000001000000010000000300000000000A00010000000000060051004A000A00790064000600AE009C000600C5009C000600E2009C00060001019C0006001A019C00060033019C0006004E019C00060069019C00060082019C0006009B019C000600CB01B8013700DF01000006000E02EE0106002E02EE010A00900275020600CE02C4020E00F102DB020600FC02C4020E000303DB02060024034A0000000000010000000000010001000100100037000000050001000100502100000000960082000A000100D821000000008618870011000200000001008D00190087001500210087001500290087001500310087001500390087001500410087001500490087001500510087001500590087001500610087001500690087001A007900870020008100870011008900870011001100A5026C011100B00270011100BB027401910087001100990087007901110013038101A1001E038601B10030031100910\
038038101110087008E010900870011002000730047012E002B009D012E001300C2012E001B00C2012E002300C8012E000B009D012E003300DE012E003B00C2012E0053000B022E005B0018022E00630021022E006B002A0294010480000001000000000000000100000025004C0200000200000000000000000000000100410000000000020000000000000000000000010058000000000002000000000000000000000001004A00000000000000003C4D6F64756C653E005374616972776179546F53514C434C522D30355F4672616D65776F726B56657273696F6E546573742E646C6C00475A69705374756666006D73636F726C69620053797374656D004F626A6563740053797374656D2E446174610053797374656D2E446174612E53716C54797065730053716C427974657300475A6970002E63746F720044617461546F436F6D70726573730053797374656D2E5265666C656374696F6E00417373656D626C795469746C6541747472696275746500417373656D626C794465736372697074696F6E41747472696275746500417373656D626C79436F6E66696775726174696F6E41747472696275746500417373656D626C79436F6D70616E7941747472696275746500417373656D626C7950726F6475637441747472696275746500417373656D626C79436F70797269676874417474726\
96275746500417373656D626C7954726164656D61726B41747472696275746500417373656D626C7943756C7475726541747472696275746500417373656D626C7956657273696F6E41747472696275746500417373656D626C7946696C6556657273696F6E4174747269627574650053797374656D2E446961676E6F73746963730044656275676761626C6541747472696275746500446562756767696E674D6F6465730053797374656D2E52756E74696D652E436F6D70696C6572536572766963657300436F6D70696C6174696F6E52656C61786174696F6E734174747269627574650052756E74696D65436F6D7061746962696C697479417474726962757465005374616972776179546F53514C434C522D30355F4672616D65776F726B56657273696F6E54657374004D6963726F736F66742E53716C5365727665722E5365727665720053716C46756E6374696F6E417474726962757465006765745F49734E756C6C006765745F4C656E677468006765745F4E756C6C0053797374656D2E494F004D656D6F727953747265616D0053797374656D2E494F2E436F6D7072657373696F6E00475A697053747265616D0053747265616D00436F6D7072657373696F6E4D6F6465006765745F4275666665720057726974650049446973706F7361626C6500446973706F736500546F41727261790\
0000320000000000060FA8703164B214FBB6FACECE6C9A9030008B77A5C561934E0890600011209120903200001042001010E05200101113904200101088120002400000480000014010000060200000024000052534131000800000100010015D140D82785C0041026CA9177DB80AC0B2205FB9A83976A4BCFF8326857BE3C27E33062360083EB9614C1B431A3B4BAB25206B63727545F69F74ADC815F6E1B2A0D6235E06A67FBB3E09EF95BBEF01943D893B040BDD3E5AF895CFD1262F25B0F97540492724F5868615EE6129BAC6FA7C8BBE6717AAFB91580DD433BE970C606B9F470DCE681A65D9C12F521789993D247098C3F46FFBB9FC2E7F96296EBC380153E2B801641358B185D78B4BDEE0E1BA3415BDEA474473C4DF1C7B745D61113823755DCF12A58A11E33AB4F1DAECE73CE14D1F72CE7191456FB5A5455BB3F68C449575D8D201E4336246D865916B3EFE166D83AD44EC3CC759498F67781BB240100020054020F497344657465726D696E69737469630154020949735072656369736501032000020320000A040000120907200201125111550420001D05072003011D050808052001011D0508070312091249124D2401001F5374616972776179546F53514C434C525F30355F446576656C6F706D656E7400000501000000001501001053716C205175616E74756D204C65617000002\
C010027436F7079726967687420C2A920323031352053716C205175616E74756D204C6561702C204C4C4300000C010007312E302E302E3000000801000200000000000801000800000000001E01000100540216577261704E6F6E457863657074696F6E5468726F77730100000000000000F1EBC75400000000020000001C0100004C2A00004C0C0000525344531F66BD3BEF5ECB4F8763C628299EC06107000000633A5C50686F656E697850726F6A6563745C41727469636C65735C5374616972776179546F53514C434C525C4C6576656C2D3520446576656C6F706D656E745C436F64655C5374616972776179546F53514C434C522D30352D4672616D65776F726B56657273696F6E546573745C5374616972776179546F53514C434C522D30352D4672616D65776F726B56657273696F6E546573745C6F626A5C52656C656173655C5374616972776179546F53514C434C522D30355F4672616D65776F726B56657273696F6E546573742E7064620000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000902B00000000000000000000AE2B0000002000000000000000000000000000000000000000000000A02B000000000000000000000000000000005F436F72446C6C4D61696E006D73636F7265652E646C6C0\
000000000FF250020001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100100000001800008000000000000000000000000000000100010000003000008000000000000000000000000000000100000000004800000058400000F80300000000000000000000F80334000000560053005F00560045005200530049004F004E005F0049004E0046004F0000000000BD04EFFE00000100000001000000000000000100000000003F000000000000000400000002000000000000000000000000000000440000000100560061007200460069006C00650049006E0066006F00000000002400040000005400720061006E0073006C006100740069006F006E00000000000000B00458030000010053007400720069006E006700460069006C00650049006E0066006F00000034030000010030003000300030003000340062003000000044001100010043006F006D00700061006E0079004E0061006D00650000000000530071006C0020005100750061006E00740075006D0020004C0065006100700000000000680020000100460069006C0065004400650073006300720069007000740069006F006E0000000000530074006100690072007700610079005\
4006F00530051004C0043004C0052005F00300035005F0044006500760065006C006F0070006D0065006E0074000000300008000100460069006C006500560065007200730069006F006E000000000031002E0030002E0030002E00300000007C002D00010049006E007400650072006E0061006C004E0061006D00650000005300740061006900720077006100790054006F00530051004C0043004C0052002D00300035005F004600720061006D00650077006F0072006B00560065007200730069006F006E0054006500730074002E0064006C006C00000000007400270001004C006500670061006C0043006F007000790072006900670068007400000043006F0070007900720069006700680074002000A900200032003000310035002000530071006C0020005100750061006E00740075006D0020004C006500610070002C0020004C004C0043000000000084002D0001004F0072006900670069006E0061006C00460069006C0065006E0061006D00650000005300740061006900720077006100790054006F00530051004C0043004C0052002D00300035005F004600720061006D00650077006F0072006B00560065007200730069006F006E0054006500730074002E0064006C006C0000000000600020000100500072006F0064007500630074004E0061006D006500000000005300740\
061006900720077006100790054006F00530051004C0043004C0052005F00300035005F0044006500760065006C006F0070006D0065006E0074000000340008000100500072006F006400750063007400560065007200730069006F006E00000031002E0030002E0030002E003000000038000800010041007300730065006D0062006C0079002000560065007200730069006F006E00000031002E0030002E0030002E0030000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002000000C000000C03B00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
		WITH PERMISSION_SET = SAFE;
	PRINT 'Done.';
	PRINT '';

	PRINT 'Creating Scalar Function [GZip] ...';
	EXEC('
CREATE FUNCTION [dbo].[GZip] (@DataToCompress VARBINARY (MAX))
RETURNS VARBINARY (MAX)
AS EXTERNAL NAME [StairwayToSQLCLR-05_FrameworkVersionTest].[GZipStuff].[GZip];
	');
	PRINT 'Done.';
	PRINT '';

	------------------------------

	SELECT dbo.GZip(CONVERT(VARBINARY(4000), N'OMG! This is such a test!'));

	-- On SQL Server 2005 / 2008 / 2008 R2, or 2012 / 2014 IF the server has not been updated with at least .NET Framework 4.5
	-- 0x1F8B0800000000000400EDBD07601C499625262F6DCA7B7F4AF54AD7E074A10880601324D8904010ECC188CDE692EC1D69472329AB2A81CA6556655D661640CCED9DBCF7DE7BEFBDF7DE7BEFBDF7BA3B9D4E27F7DFFF3F5C6664016CF6CE4ADAC99E2180AAC81F3F7E7C1F3F22BEFC35BEF8353EFF357ED75F23FD35DEFC1AF35FA3F8351AFA4DFE6D7E8DF5AF31A5CFD25F23A3FFB7BF464E9FB4BFC6EFFA6BFC3F019BA23D32000000

	-- On SQL Server 2012 / 2014 IF the server has been updated with at least .NET Framework 4.5
	-- 0x1F8B0800000000000400F367F0657067506450600861C860C8642806B220643143294332504C812111884B1852812225409500019BA23D32000000


	------------------------------

END TRY
BEGIN CATCH

	DECLARE @Message NVARCHAR(4000);
	SET @Message = ERROR_MESSAGE();

	RAISERROR(@Message, 16, 1);

END CATCH;
GO

