/**********************************************
 * StairwayToSQLCLR-05-03-SupportedLibraryTest.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 5: Development (Using .NET within SQL Server)
 * http://www.sqlservercentral.com/articles/SQLCLR/119429/
 * 
 * Copyright (C) 2015 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/
 
USE [StairwayToSQLCLR];
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO

BEGIN TRY

	-- Create an Asymmetric Key based on info stored in the Assembly's source DLL file.
	-- Re-use same Key from prior level of Stairway to SQLCLR for simplicity.
	IF (NOT EXISTS (
					SELECT	*
					FROM	[master].sys.asymmetric_keys ak
					WHERE	ak.name = N'StairwayToSQLCLR-04-Key1'
				)
		)
	BEGIN
		PRINT 'Creating test Asymmetric Key [StairwayToSQLCLR-04-Key1] ...';
		-- Do this within an EXEC to keep the database context as StairwayToSQLCLR
		EXEC ('USE [master];
				CREATE ASYMMETRIC KEY [StairwayToSQLCLR-04-Key1]
					AUTHORIZATION [dbo]
					FROM EXECUTABLE FILE = ''C:\TEMP\StairwayToSQLCLR\Level-04\Assemblies\StairwayToSQLCLR-04-Security2_ExternalAccess.dll'';
		');
		PRINT 'Done.';
	END;
	ELSE
	BEGIN
		PRINT '[StairwayToSQLCLR-04-Key1] test Asymmetric Key already exists.';
	END;

	PRINT '--------------------';
	------------------------------


	-- Create a Login based on the Asymmetric Key we just created above.
	-- Re-use same Login from prior level of Stairway to SQLCLR for simplicity.
	IF (NOT EXISTS (
					SELECT	*
					FROM	[master].sys.server_principals sp
					WHERE	sp.name = N'MrStairwayToSQLCLR'
				)
		)
	BEGIN
		PRINT 'Creating test SQL Server Login [MrStairwayToSQLCLR] ...';
		CREATE LOGIN [MrStairwayToSQLCLR]
			FROM ASYMMETRIC KEY [StairwayToSQLCLR-04-Key1];
		PRINT 'Done.';
	END;
	ELSE
	BEGIN
		PRINT '[MrStairwayToSQLCLR] test Login already exists.';
	END;

	PRINT '--------------------';
	------------------------------

	-- Grant the desired permission to the Login we just created.
	-- Do this within an EXEC to keep the database context as StairwayToSQLCLR
	EXEC ('USE [master];
			GRANT UNSAFE ASSEMBLY TO [MrStairwayToSQLCLR];
	');

	------------------------------

	IF (OBJECT_ID(N'dbo.GetTokyoTime') IS NOT NULL)
	BEGIN
		PRINT N'Dropping Stored Procedure [GetTokyoTime] ...';
		DROP PROCEDURE [dbo].[GetTokyoTime];
		PRINT 'Done.';
		PRINT '';
	END;

	IF (ASSEMBLYPROPERTY(N'StairwayToSQLCLR-05_SupportedLibraryTest', 'SimpleName') IS NOT NULL)
	BEGIN
		PRINT 'Dropping Assembly [StairwayToSQLCLR-05_SupportedLibraryTest] ...';
		DROP ASSEMBLY [StairwayToSQLCLR-05_SupportedLibraryTest];
		PRINT 'Done.';
		PRINT '';
	END;

	------

	PRINT 'Creating Assembly [StairwayToSQLCLR-05_SupportedLibraryTest] ...';
	CREATE ASSEMBLY [StairwayToSQLCLR-05_SupportedLibraryTest]
		AUTHORIZATION [dbo]
		FROM 0x4D5A90000300000004000000FFFF0000B800000000000000400000000000000000000000000000000000000000000000000000000000000000000000800000000E1FBA0E00B409CD21B8014CCD21546869732070726F6772616D2063616E6E6F742062652072756E20696E20444F53206D6F64652E0D0D0A2400000000000000504500004C01030039EEC7540000000000000000E00002210B010B00000C000000080000000000005E2B00000020000000400000000000100020000000020000040000000000000004000000000000000080000000020000D2CB0000030040850000100000100000000010000010000000000000100000000000000000000000082B000053000000004000004004000000000000000000000000000000000000006000000C000000D02900001C0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000200000080000000000000000000000082000004800000000000000000000002E74657874000000640B000000200000000C000000020000000000000000000000000000200000602E72737263000000400400000040000000060000000E0000000000000000000000000000400000402E72656C6F6300000C0000000060000000020000001400000000000000000000000000004000004\
200000000000000000000000000000000402B00000000000048000000020005009C210000340800000900000000000000000000000000000050200000000100000000000000000000000000000000000000000000000000000000000000000000E3F446DD7BDFF3972C98E09B8BF673E6781A82DFF8CFE564EA149BF7EC7FC2BC2293EFDFDA9D6A1A827F288FB38B1E5367AF7E9783C88D3C8619E3A8138E60304E8E935C28EA82AA11D3BB307BDAC5BC059D26422425DE50207053E0AF44B25F783C409AFE774A957412A5A87854FA1E368BB41F8F43963B69527D95353F44F3FB9060BBB8562AEA7687472189633DDF33A6E7460CF4AE2777E6315051A8B56E5664CBC8ADB7C1DD4C350D737CF617A0294228F389F5A026D793516C9F736A04EBB2C3044474EB75A64A96F202254F76ED61E669E79DDF48E2AEC50215CB85EE10A0F76B53C404666DD6B96F2907F02EC5986547578DD704B30B70C37FAFD9601330030037000000010000117201000070280F00000A0A281000000A281100000A06281200000A0B281300000A7229000070078C12000001281400000A6F1500000A2A1E02281600000A2A0042534A4201000100000000000C00000076322E302E35303732370000000005006C00000020020000237E00008C0200000C03000023537472696E677300000000980500005000000023555\
300E8050000100000002347554944000000F80500003C02000023426C6F620000000000000002000001471402000900000000FA25330016000001000000150000000200000002000000160000000C00000001000000010000000300000000000A00010000000000060055004E00060081006F00060098006F000600B5006F000600D4006F000600ED006F00060006016F00060021016F0006003C016F00060055016F0006006E016F0006009E018B013300B20100000600E101C10106000102C1010A006F0254020E0091024E000600B5024E000A00DC0254020A00E70254020600F8024E000000000001000000000001000100010010003700000005000100010050210000000096005C000A000100932100000000861869000E000100110069001200190069001200210069001200290069001200310069001200390069001200410069001200490069001200510069001200590069001200610069001700710069001D00790069000E00810069000E0089009E0249019100BE024F018900C60254018900D00259019900EF026401A900FF026901A10006031200090069000E002000730044012E002B00AE012E00130092012E001B0092012E00230098012E000B0076012E003300C6012E003B0092012E005300FC012E005B0009022E00630012022E006B001B026F0104800000010000000000000\
00100000022001F02000002000000000000000000000001004500000000000200000000000000000000000100480200000000030005000000000000000000010085020000000000000000003C4D6F64756C653E005374616972776179546F53514C434C522D30355F537570706F727465644C696272617279546573742E646C6C0054696D655A6F6E655374756666006D73636F726C69620053797374656D004F626A65637400476574546F6B796F54696D65002E63746F720053797374656D2E5265666C656374696F6E00417373656D626C795469746C6541747472696275746500417373656D626C794465736372697074696F6E41747472696275746500417373656D626C79436F6E66696775726174696F6E41747472696275746500417373656D626C79436F6D70616E7941747472696275746500417373656D626C7950726F6475637441747472696275746500417373656D626C79436F7079726967687441747472696275746500417373656D626C7954726164656D61726B41747472696275746500417373656D626C7943756C7475726541747472696275746500417373656D626C7956657273696F6E41747472696275746500417373656D626C7946696C6556657273696F6E4174747269627574650053797374656D2E446961676E6F73746963730044656275676761626C65417474726\
96275746500446562756767696E674D6F6465730053797374656D2E52756E74696D652E436F6D70696C6572536572766963657300436F6D70696C6174696F6E52656C61786174696F6E734174747269627574650052756E74696D65436F6D7061746962696C697479417474726962757465005374616972776179546F53514C434C522D30355F537570706F727465644C696272617279546573740053797374656D2E44617461004D6963726F736F66742E53716C5365727665722E5365727665720053716C50726F6365647572654174747269627574650053797374656D2E436F72650054696D655A6F6E65496E666F0046696E6453797374656D54696D655A6F6E6542794964004461746554696D65006765745F4E6F77006765745F4C6F63616C00436F6E7665727454696D650053716C436F6E746578740053716C50697065006765745F5069706500537472696E6700466F726D61740053656E640000002754006F006B0079006F0020005300740061006E0064006100720064002000540069006D0065000025540069006D006500200069006E00200054006F006B0079006F003A0020007B0030007D00000036423888BBCA0D40BACC6155990D16CE0008B77A5C561934E0890300000103200001042001010E05200101113504200101088120002400000480000014010000060200000024000\
052534131000800000100010015D140D82785C0041026CA9177DB80AC0B2205FB9A83976A4BCFF8326857BE3C27E33062360083EB9614C1B431A3B4BAB25206B63727545F69F74ADC815F6E1B2A0D6235E06A67FBB3E09EF95BBEF01943D893B040BDD3E5AF895CFD1262F25B0F97540492724F5868615EE6129BAC6FA7C8BBE6717AAFB91580DD433BE970C606B9F470DCE681A65D9C12F521789993D247098C3F46FFBB9FC2E7F96296EBC380153E2B801641358B185D78B4BDEE0E1BA3415BDEA474473C4DF1C7B745D61113823755DCF12A58A11E33AB4F1DAECE73CE14D1F72CE7191456FB5A5455BB3F68C449575D8D201E4336246D865916B3EFE166D83AD44EC3CC759498F67781BB040100000005000112450E040000114904000012450A0003114911491245124504000012510500020E0E1C060702124511491B0100164672616D65776F726B2056657273696F6E205465737400000501000000001501001053716C205175616E74756D204C656170000017010012537461697277617920746F2053514C434C52000035010030323031342053716C205175616E74756D204C6561702C204C4C432E20416C6C205269676874732052657365727665642E00000C010007312E302E302E3000000801000200000000000801000800000000001E01000100540216577261704E6F6E457863657\
074696F6E5468726F77730100000000000039EEC75400000000020000001C010000EC290000EC0B0000525344532B4A46546D6A494BA6BC2F5EB02C2C3D04000000633A5C50686F656E697850726F6A6563745C41727469636C65735C5374616972776179546F53514C434C525C4C6576656C2D3520446576656C6F706D656E745C436F64655C5374616972776179546F53514C434C522D30352D537570706F727465644C696272617279546573745C5374616972776179546F53514C434C522D30352D537570706F727465644C696272617279546573745C6F626A5C52656C656173655C5374616972776179546F53514C434C522D30355F537570706F727465644C696272617279546573742E7064620000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000302B000000000000000000004E2B0000002000000000000000000000000000000000000000000000402B000000000000000000000000000000005F436F72446C6C4D61696E006D73636F7265652E646C6C0000000000FF2500200010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100100000001800008000000000000000000000000000000100010000003000008000000000000000000000000000000100000000004800000058400000E40300000000000000000000E40334000000560053005F00560045005200530049004F004E005F0049004E0046004F0000000000BD04EFFE00000100000001000000000000000100000000003F000000000000000400000002000000000000000000000000000000440000000100560061007200460069006C00650049006E0066006F00000000002400040000005400720061006E0073006C006100740069006F006E00000000000000B00444030000010053007400720069006E006700460069006C00650049006E0066006F00000020030000010030003000300030003000340062003000000044001100010043006F006D00700061006E0079004E0061006D00650000000000530071006C0020005100750061006E00740075006D0020004C0065006100700000000000580017000100460069006C0065004400650073006300720069007000740069006F006E00000000004600720061006D00650077006F0072006\
B002000560065007200730069006F006E002000540065007300740000000000300008000100460069006C006500560065007200730069006F006E000000000031002E0030002E0030002E00300000007C002D00010049006E007400650072006E0061006C004E0061006D00650000005300740061006900720077006100790054006F00530051004C0043004C0052002D00300035005F0053007500700070006F0072007400650064004C0069006200720061007200790054006500730074002E0064006C006C00000000008800310001004C006500670061006C0043006F007000790072006900670068007400000032003000310034002000530071006C0020005100750061006E00740075006D0020004C006500610070002C0020004C004C0043002E00200041006C006C0020005200690067006800740073002000520065007300650072007600650064002E000000000084002D0001004F0072006900670069006E0061006C00460069006C0065006E0061006D00650000005300740061006900720077006100790054006F00530051004C0043004C0052002D00300035005F0053007500700070006F0072007400650064004C0069006200720061007200790054006500730074002E0064006C006C0000000000480013000100500072006F0064007500630074004E0061006D0065000000000\
053007400610069007200770061007900200074006F002000530051004C0043004C00520000000000340008000100500072006F006400750063007400560065007200730069006F006E00000031002E0030002E0030002E003000000038000800010041007300730065006D0062006C0079002000560065007200730069006F006E00000031002E0030002E0030002E00300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000002000000C000000603B00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
		WITH PERMISSION_SET = SAFE;
	PRINT 'Done.';
	PRINT '';

	PRINT 'Altering PERMISSION_SET on [StairwayToSQLCLR-05_SupportedLibraryTest] to UNSAFE ...';
	ALTER ASSEMBLY [StairwayToSQLCLR-05_SupportedLibraryTest]
		WITH PERMISSION_SET = UNSAFE;
	PRINT 'Done.';
	PRINT '';


	PRINT 'Creating Stored Procedure [GetTokyoTime] ...';
	EXEC('
CREATE PROCEDURE [dbo].[GetTokyoTime]
AS EXTERNAL NAME [StairwayToSQLCLR-05_SupportedLibraryTest].[TimeZoneStuff].[GetTokyoTime];
	');
	PRINT 'Done.';
	PRINT '';

	------------------------------

	EXEC dbo.GetTokyoTime;

	------------------------------

END TRY
BEGIN CATCH

	DECLARE @Message NVARCHAR(4000);
	SET @Message = ERROR_MESSAGE();

	RAISERROR(@Message, 16, 1);

END CATCH;
GO


/*
-- You would need to do the following on SQL Server 2005 (assuming that
-- .NET 3.5 has been installed) in order to get this script to run
-- successfully.

	-- System.Core.dll has to be loaded as UNSAFE so we need to allow it.
	ALTER DATABASE [StairwayToSQLCLR]
		SET TRUSTWORTHY ON;


	-- Load System.Core.dll into the database
	USE [StairwayToSQLCLR]
	CREATE ASSEMBLY [System.Core]
		AUTHORIZATION [dbo]
		FROM 'C:\Program Files\Reference Assemblies\Microsoft\Framework\v3.5\System.Core.dll'
		WITH PERMISSION_SET = UNSAFE;

*/