/**********************************************
 * StairwayToSQLCLR-05-02-EnableCLR.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 5: Development (Using .NET within SQL Server)
 * http://www.sqlservercentral.com/articles/SQLCLR/119429/
 * 
 * Copyright (C) 2015 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

IF (DB_ID(N'StairwayToSQLCLR') IS NULL)
BEGIN
	RAISERROR(N'Please run script 01 first to create the [StairwayToSQLCLR] test DB.', 16, 1);
	RETURN;
END;
GO


USE [StairwayToSQLCLR];
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;


DECLARE @DidWeEnableCLR BIT;
SET @DidWeEnableCLR = 0;


IF (EXISTS(
	-- Highlight below query and F5 / Ctrl-E to see details
	SELECT *
	FROM sys.configurations
	WHERE configuration_id = 1562 -- name = "clr enabled"
	-- Highlight above query and F5 / Ctrl-E to see details
	AND value_in_use = 0
	))
BEGIN
	PRINT 'Enabling CLR...';
	EXEC sp_configure 'clr enabled', 1;

	-- Uncomment the WITH OVERRIDE if you get the
	-- "ad hoc changes are not allowed" error
	PRINT 'Reconfiguring...';
	RECONFIGURE; --WITH OVERRIDE;
	PRINT 'Done.';

	SET @DidWeEnableCLR = 1;
END;
ELSE
BEGIN
	PRINT 'CLR already enabled.';
END;

PRINT '--------------------';
------------------------------

IF (OBJECT_ID(N'DidWeEnableCLR') IS NULL)
BEGIN
	PRINT 'Creating [DidWeEnableCLR] function to indicate that it was this script that enabled CLR Integration...';
	PRINT 'This will be useful for the script that disables CLR Integration since we won''t want to disable CLR';
	PRINT '  if it was enabled prior to these example scrips being run.';

	DECLARE @SQL NVARCHAR(MAX);

	SET @SQL = N'
	CREATE FUNCTION dbo.DidWeEnableCLR ()
	RETURNS BIT
	AS
	BEGIN
		RETURN CONVERT(BIT, ' + CONVERT(NVARCHAR(10), @DidWeEnableCLR) + N');
	END;
	';

	EXEC(@SQL);
END;
ELSE
BEGIN
	PRINT '[DidWeEnableCLR] function already exists.';
END;


PRINT '--------------------';
------------------------------

PRINT 'DidWeEnableCLR = ' + CONVERT(NVARCHAR(10), dbo.DidWeEnableCLR());
