/**********************************************
 * StairwayToSQLCLR-05-01-CreateDatabase.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 5: Development (Using .NET within SQL Server)
 * http://www.sqlservercentral.com/articles/SQLCLR/119429/
 * 
 * Copyright (C) 2015 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

USE [master];
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO
------------------------------

IF (DB_ID(N'StairwayToSQLCLR') IS NULL)
BEGIN
	PRINT 'Creating [StairwayToSQLCLR] test DB...';
	CREATE DATABASE [StairwayToSQLCLR];
END;
ELSE
BEGIN
	PRINT 'Test DB [StairwayToSQLCLR] already exists...';
END;


IF (EXISTS(
			SELECT	*
			FROM	sys.databases sd
			WHERE	sd.[name] = N'StairwayToSQLCLR'
			AND		(
						sd.recovery_model <> 3
					OR	sd.is_broker_enabled = 1
					)
			)
	)
BEGIN
	PRINT 'Altering test DB...';
	ALTER DATABASE [StairwayToSQLCLR]
		SET	RECOVERY SIMPLE,
			DISABLE_BROKER
		WITH ROLLBACK IMMEDIATE;
END;

PRINT '--------------------';
------------------------------
GO
