using System.Data.SqlTypes;
using System.IO;
using System.IO.Compression;

public class GZipStuff
{
    [Microsoft.SqlServer.Server.SqlFunction(IsDeterministic = true,
        IsPrecise = true)]
    public static SqlBytes GZip(SqlBytes DataToCompress)
    {
        if (DataToCompress.IsNull || DataToCompress.Length == 0)
        {
            return SqlBytes.Null;
        }

        SqlBytes __Output;

        using (MemoryStream __MemoryStream = new MemoryStream())
        {
            using (GZipStream __GZipStream =
                    new GZipStream(__MemoryStream, CompressionMode.Compress))
            {
                __GZipStream.Write(DataToCompress.Buffer,
                                    0, (int)DataToCompress.Length);
            }
            __Output = new SqlBytes(__MemoryStream.ToArray());
        }

        return __Output;
    }
}


