/**********************************************
 * StairwayToSQLCLR-04-09-DisableCLR.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 4: Security (EXTERNAL_ACCESS and UNSAFE Assemblies)
 * http://www.sqlservercentral.com/articles/Stairway+Series/112888/
 * 
 * Copyright (C) 2014 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

USE [StairwayToSQLCLR];
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO

IF (EXISTS(
	-- Highlight below query and F5 / Ctrl-E to see details
	SELECT *
	FROM sys.configurations
	WHERE configuration_id = 1562 -- name = "clr enabled"
	-- Highlight above query and F5 / Ctrl-E to see details
	AND value_in_use = 1
	))
BEGIN
	IF (dbo.DidWeEnableCLR() = 1)
	BEGIN
		PRINT 'Disabling CLR...';
		EXEC sp_configure 'clr enabled', 0;

		-- Uncomment the WITH OVERRIDE if you get the
		-- "ad hoc changes are not allowed" error
		PRINT 'Reconfiguring...';
		RECONFIGURE; --WITH OVERRIDE;
		PRINT 'Done.';
	END
	ELSE
	BEGIN
		RAISERROR (N'
		CLR Integration was enabled prior to the "Stairway To SQLCLR" example
		  scripts being run.  No changes to make; CLR Integration will remain Enabled.', 11, 1);
	END;
END
ELSE
BEGIN
	PRINT 'CLR already Disabled.';
END;
GO
