/**********************************************
 * StairwayToSQLCLR-04-08-PointsOfInterestTests.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 4: Security (EXTERNAL_ACCESS and UNSAFE Assemblies)
 * http://www.sqlservercentral.com/articles/Stairway+Series/112888/
 * 
 * Copyright (C) 2014 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

USE [StairwayToSQLCLR];
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO


----------------------------------------------------------

EXEC (N'USE [master]; REVOKE EXTERNAL ACCESS ASSEMBLY, UNSAFE ASSEMBLY TO [MrStairwayToSQLCLR];');
EXEC (N'USE [master]; REVOKE EXTERNAL ACCESS ASSEMBLY, UNSAFE ASSEMBLY TO [MrsStairwayToSQLCLR];');

-- The following needs UNSAFE, is a runtime check, and worked fine just prior to
-- running the above REVOKE.
EXEC dbo.StairwayToSQLCLR_04_Beep;
/*
Msg 10314, Level 16, State 11, Line 1
   An error occurred in the Microsoft .NET Framework while trying to load assembly
   id 65547. The server may be running out of resources, or the assembly may not be
   trusted with PERMISSION_SET = EXTERNAL_ACCESS or UNSAFE. Run the query again, or
   check documentation to see how to solve the assembly trust issues. For more
   information about this error: 
   System.IO.FileLoadException: Could not load file or assembly
   'stairwaytosqlclr-04-security2_runtimecheck, Version=1.0.0.0, Culture=neutral,
   PublicKeyToken=6c7843d081193a36' or one of its dependencies. An error relating
   to security occurred. (Exception from HRESULT: 0x8013150A)
*/


-- The following needs UNSAFE, is a CREATE ASSEMBLY check, and worked fine just
-- prior to running the above REVOKE.
SELECT dbo.StairwayToSQLCLR_04_GetSharedValue();
/*
Msg 10314, Level 16, State 11, Line 1
   An error occurred in the Microsoft .NET Framework while trying to load assembly
   id 65548. The server may be running out of resources, or the assembly may not be
   trusted with PERMISSION_SET = EXTERNAL_ACCESS or UNSAFE. Run the query again, or
   check documentation to see how to solve the assembly trust issues. For more
   information about this error: 
   System.IO.FileLoadException: Could not load file or assembly
   'stairwaytosqlclr-04-security2_createassemblycheck, Version=1.0.0.0,
   Culture=neutral, PublicKeyToken=147e18278b82e982' or one of its dependencies.
   An error relating to security occurred. (Exception from HRESULT: 0x8013150A)
*/


-- The following needs EXTERNAL_ACCESS, is a runtime check, and worked fine just
-- prior to running the above REVOKE.
EXEC dbo.StairwayToSQLCLR_04_WhoAmI @ServerName = '(local)', @Impersonate = 0;
-- error:
/*
Msg 10314, Level 16, State 11, Line 1
   An error occurred in the Microsoft .NET Framework while trying to load assembly
   id 65543. The server may be running out of resources, or the assembly may not be
   trusted with PERMISSION_SET = EXTERNAL_ACCESS or UNSAFE. Run the query again, or
   check documentation to see how to solve the assembly trust issues. For more
   information about this error: 
   System.IO.FileLoadException: Could not load file or assembly
   'stairwaytosqlclr-04-security2_externalaccess, Version=1.0.0.0,
   Culture=neutral, PublicKeyToken=147e18278b82e982' or one of its dependencies.
   An error relating to security occurred. (Exception from HRESULT: 0x8013150A)
*/

GO

----------------------------------------------------------

-- Re-GRANT the Login permissions
EXEC ('USE [master]; GRANT UNSAFE ASSEMBLY TO [MrStairwayToSQLCLR];');

-- The following needs UNSAFE, is a CREATE ASSEMBLY check, worked prior to running
-- the REVOKE, but got an error after the REVOKE.
SELECT dbo.StairwayToSQLCLR_04_GetSharedValue();
-- no error; it works again

----------------------------------------------------------

-- The Assembly is working again, but what if we remove the Login that was created
-- from the same Asymmetric Key or Certificate that was used to sign the Assembly?

-- drop just the Login, but not the Asymmetric Key
DROP LOGIN [MrStairwayToSQLCLR];
-- no error


SELECT dbo.StairwayToSQLCLR_04_GetSharedValue();

-- Same "Msg 10314, Level 16, State 11" error that we saw above. Hence, setting an
-- Assembly to EXTERNAL_ACCESS or UNSAFE is not a permanent guarantee of being able
-- to run that code! Assemblies cannot be "grandfathered" into a PERMISSION_SET.
