/**********************************************
 * StairwayToSQLCLR-04-06-UnsafeTests1.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 4: Security (EXTERNAL_ACCESS and UNSAFE Assemblies)
 * http://www.sqlservercentral.com/articles/Stairway+Series/112888/
 * 
 * Copyright (C) 2014 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

USE [StairwayToSQLCLR];
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO


----------------------------------------------------------
-- We can't load [StairwayToSQLCLR-04-Security2_CreateAssemblyCheck] as either
-- SAFE or EXTERNAL_ACCESS so we need to try loading it as UNSAFE.

CREATE ASSEMBLY [StairwayToSQLCLR-04-Security2_CreateAssemblyCheck]
	AUTHORIZATION [dbo]
	FROM 'C:\TEMP\StairwayToSQLCLR\Level-04\Assemblies\StairwayToSQLCLR-04-Security2_CreateAssemblyCheck.dll'
	WITH PERMISSION_SET = UNSAFE;
/*
Msg 10327, Level 14, State 1, Line 1
   CREATE ASSEMBLY for assembly 'StairwayToSQLCLR-04-Security2_CreateAssemblyCheck'
   failed because assembly 'StairwayToSQLCLR-04-Security2_CreateAssemblyCheck' is
   not authorized for PERMISSION_SET = UNSAFE.  The assembly is authorized when
   either of the following is true: the database owner (DBO) has UNSAFE ASSEMBLY
   permission and the database has the TRUSTWORTHY database property on; or the
   assembly is signed with a certificate or an asymmetric key that has a
   corresponding login with UNSAFE ASSEMBLY permission.
*/

-- The Login has, so far, only been granted permission to have EXTERNAL ACCESS
-- Assemblies but not UNSAFE Assemblies.


EXEC ('USE [master];
		GRANT UNSAFE ASSEMBLY TO [MrStairwayToSQLCLR];
');
-- no errors


-- Try again:
CREATE ASSEMBLY [StairwayToSQLCLR-04-Security2_CreateAssemblyCheck]
	AUTHORIZATION [dbo]
	FROM 'C:\TEMP\StairwayToSQLCLR\Level-04\Assemblies\StairwayToSQLCLR-04-Security2_CreateAssemblyCheck.dll'
	WITH PERMISSION_SET = UNSAFE;
-- no errors


-- In the previous script we couldn't set [StairwayToSQLCLR-04-Security2_ExternalAccess]
-- to UNSAFE.  Can we now?
ALTER ASSEMBLY [StairwayToSQLCLR-04-Security2_ExternalAccess] WITH PERMISSION_SET = UNSAFE;
-- no errors


-- The Login was created from an Asymmetric Key that was created from the Private
-- Key that was used to sign the [StairwayToSQLCLR-04-Security2_ExternalAccess]
-- source DLL. The [StairwayToSQLCLR-04-Security2_CreateAssemblyCheck] Assembly
-- was allowed to be set to UNSAFE because it was signed with the same Private Key.
-- The only indication (so far) that they used the same Private Key is that we were
-- able to set this Assembly to UNSAFE without doing the other steps. In the next
-- script we will see an indicator of which Assemblies are using the same Private Key.
GO
CREATE FUNCTION [dbo].[StairwayToSQLCLR_04_SetSharedValue]
(
	@ValueToSet NVARCHAR(4000)
)
RETURNS NVARCHAR(4000)
WITH RETURNS NULL ON NULL INPUT
AS EXTERNAL NAME [StairwayToSQLCLR-04-Security2_CreateAssemblyCheck].[SqlClrSecurity_CreateAssemblyCheck].[SetSharedValue]
GO


CREATE FUNCTION [dbo].[StairwayToSQLCLR_04_GetSharedValue] ()
RETURNS NVARCHAR(4000)
AS EXTERNAL NAME [StairwayToSQLCLR-04-Security2_CreateAssemblyCheck].[SqlClrSecurity_CreateAssemblyCheck].[GetSharedValue]
GO

----------------------------------------------------------

-- set a value; first run will return an empty string
SELECT dbo.StairwayToSQLCLR_04_SetSharedValue('test');

-- set a value; return is the previous value that was set
SELECT dbo.StairwayToSQLCLR_04_SetSharedValue('what now?');

SELECT dbo.StairwayToSQLCLR_04_GetSharedValue();



----------------------------------------------------------
-- Clean Up!
/*
IF (OBJECT_ID(N'dbo.StairwayToSQLCLR_04_SetSharedValue') IS NOT NULL)
BEGIN
	PRINT 'Dropping function [StairwayToSQLCLR_04_SetSharedValue] ...';
	DROP FUNCTION [dbo].[StairwayToSQLCLR_04_SetSharedValue];
	PRINT 'Done.';
	PRINT '';
END;

IF (OBJECT_ID(N'dbo.StairwayToSQLCLR_04_GetSharedValue') IS NOT NULL)
BEGIN
	PRINT 'Dropping function [StairwayToSQLCLR_04_GetSharedValue] ...';
	DROP FUNCTION [dbo].[StairwayToSQLCLR_04_GetSharedValue];
	PRINT 'Done.';
	PRINT '';
END;

IF (ASSEMBLYPROPERTY(N'StairwayToSQLCLR-04-Security2_CreateAssemblyCheck', 'SimpleName') IS NOT NULL)
BEGIN
	PRINT 'Dropping Assembly [StairwayToSQLCLR-04-Security2_CreateAssemblyCheck] ...';
	DROP ASSEMBLY [StairwayToSQLCLR-04-Security2_CreateAssemblyCheck];
	PRINT 'Done.';
	PRINT '';
END;
*/

-------------------------------

