/**********************************************
 * StairwayToSQLCLR-04-03-CreateObjectsForExternalTests.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 4: Security (EXTERNAL_ACCESS and UNSAFE Assemblies)
 * http://www.sqlservercentral.com/articles/Stairway+Series/112888/
 * 
 * Copyright (C) 2014 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

USE [StairwayToSQLCLR];
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO


PRINT '--------------------';
------------------------------


-- Clean up prior install
IF (OBJECT_ID(N'dbo.WhoAmI') IS NOT NULL)
BEGIN
	PRINT 'Dropping Function [WhoAmI] ...';
	DROP FUNCTION [dbo].[WhoAmI];
	PRINT 'Done.';
	PRINT '';
END;

IF (OBJECT_ID(N'StairwayToSQLCLR_04_WhoAmI') IS NOT NULL)
BEGIN
	PRINT 'Dropping Stored Procedure [StairwayToSQLCLR_04_WhoAmI]  ...';
	DROP PROCEDURE [dbo].[StairwayToSQLCLR_04_WhoAmI];
	PRINT 'Done.';
	PRINT '';
END;

IF (ASSEMBLYPROPERTY(N'StairwayToSQLCLR-04-Security2_ExternalAccess', 'SimpleName') IS NOT NULL)
BEGIN
	PRINT 'Dropping Assembly [StairwayToSQLCLR-04-Security2_ExternalAccess] ...';
	DROP ASSEMBLY [StairwayToSQLCLR-04-Security2_ExternalAccess];
	PRINT 'Done.';
	PRINT '';
END;
GO

PRINT '--------------------';
------------------------------

-- Install Assembly and then Stored Procs and Functions
PRINT 'Creating Assembly [StairwayToSQLCLR-04-Security2_ExternalAccess] ...';
CREATE ASSEMBLY [StairwayToSQLCLR-04-Security2_ExternalAccess]
	AUTHORIZATION [dbo]
	FROM 'C:\TEMP\StairwayToSQLCLR\Level-04\Assemblies\StairwayToSQLCLR-04-Security2_ExternalAccess.dll'
	WITH PERMISSION_SET = SAFE;
PRINT 'Done.';
PRINT '';


-- This proc is used in StairwayToSQLCLR-04-04-ExternalAccessTests.sql
-- and in StairwayToSQLCLR-04-08-PointsOfInterestTests.sql
PRINT 'Creating Stored Procedure [StairwayToSQLCLR_04_WhoAmI] ...';
EXEC('
CREATE PROCEDURE [dbo].[StairwayToSQLCLR_04_WhoAmI]
(
	@ServerName NVARCHAR(200) = NULL,
	@Impersonate TINYINT = 0,
	@Message NVARCHAR(4000) = NULL
)
AS EXTERNAL NAME [StairwayToSQLCLR-04-Security2_ExternalAccess].[SqlClrSecurity_ExternalAccessAndImpersonation].[WhoAmI]
');
PRINT 'Done.';
PRINT '';


-- This function is used in StairwayToSQLCLR-04-04-ExternalAccessTests.sql
-- and in StairwayToSQLCLR-04-08-PointsOfInterestTests.sql (via [StairwayToSQLCLR_04_WhoAmI])
PRINT 'Creating Function [WhoAmI] ...';
EXEC('
CREATE FUNCTION [dbo].[WhoAmI] ()
RETURNS TABLE
WITH SCHEMABINDING
AS RETURN
SELECT	@@SERVERNAME AS [@@SERVERNAME],
		DB_NAME() AS [DB_NAME()],
		DB_ID() AS [DB_ID()],
		''---'' AS [---],
		PROGRAM_NAME() AS [PROGRAM_NAME()],
		@@SPID AS [@@SPID],
		CONTEXT_INFO() AS [CONTEXT_INFO()],
		ORIGINAL_LOGIN() AS [ORIGINAL_LOGIN()],
		''----'' AS [----],
		SUSER_ID() AS [SUSER_ID()],
		SUSER_SID() AS [SUSER_SID()],
		SUSER_NAME() AS [SUSER_NAME()],
		SUSER_SNAME() AS [SUSER_SNAME()],
		SYSTEM_USER AS [SYSTEM_USER],
		''-----'' AS [-----],
		USER_ID() AS [USER_ID()],
		USER_SID() AS [USER_SID()],
		USER_NAME() AS [USER_NAME()], -- effectively same as CURRENT_USER and USER
		SESSION_USER AS [SESSION_USER];
');

GO

PRINT '--------------------';
------------------------------

PRINT 'GRANTing permissions...';

GRANT SELECT ON dbo.WhoAmI TO PUBLIC;

GRANT EXECUTE ON dbo.StairwayToSQLCLR_04_WhoAmI TO PUBLIC;

PRINT '--------------------';
------------------------------
GO
