/**********************************************
 * ExternalAccess.cs
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 4: Security (EXTERNAL_ACCESS and UNSAFE Assemblies)
 * http://www.sqlservercentral.com/articles/Stairway+Series/112888/
 * 
 * Copyright (C) 2014 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

using System; // contains String and Exception
using System.Data; // contains CommandType and ConnectionState
using System.Data.SqlClient; // contains SqlConnection, SqlCommand, SqlDataReader
using System.Data.SqlTypes; // contains the Sql* types
using System.Security; // contains SecurityException
using System.Security.Principal; // contains WindowsImpersonationContext
using Microsoft.SqlServer.Server; // contains SqlFacet(Attribute), SqlContext

public class SqlClrSecurity_ExternalAccessAndImpersonation
{
	[Microsoft.SqlServer.Server.SqlProcedure(Name = "StairwayToSQLCLR_04_WhoAmI")]
	public static void WhoAmI([SqlFacet(MaxSize = 200)] SqlString ServerName,
		SqlByte Impersonate, SqlString Message)
	{
		string _connectionString = "context connection = true";
		WindowsImpersonationContext _impersonationIdentity = null;

		if (!ServerName.IsNull && ServerName.Value.Trim() != string.Empty)
		{
			_connectionString =
				String.Concat(	"server=",
								ServerName.Value,
								";trusted_connection=true;");
		}

		string _query = @"SELECT * FROM StairwayToSQLCLR.dbo.WhoAmI();";

		SqlDataReader _dataReader = null;
		SqlConnection _sqlConnection = new SqlConnection(_connectionString);
		SqlCommand _sqlCommand = new SqlCommand(_query, _sqlConnection);
		_sqlCommand.CommandType = CommandType.Text;

		try
		{
			// if current user is Windows Auth (i.e. NOT DB Auth) then
			// impersonate for remote calls else remote connections
			// will be made by SQL Server service account
			if (!Impersonate.IsNull &&
				  (
					(Impersonate.Value == 1 && SqlContext.WindowsIdentity != null)
				   || Impersonate.Value == 2
				  )
				)
			{
				_impersonationIdentity = SqlContext.WindowsIdentity.Impersonate();
			}

			_sqlConnection.Open();

			if (!Message.IsNull && Message.Value != "")
			{
				SqlContext.Pipe.Send(Message.Value); // PRINT @Message
			}

			if (_impersonationIdentity != null)
			{
				_impersonationIdentity.Undo();
			}

			_dataReader = _sqlCommand.ExecuteReader();

			SqlContext.Pipe.Send(_dataReader);
		}
		catch (SecurityException ex)
		{
			// If this is a Permissions error,
			// give the user some useful info to help correct it
			if (ex.PermissionType.FullName ==
						"System.Data.SqlClient.SqlClientPermission"
				|| ex.PermissionType.FullName ==
						"System.Security.Permissions.SecurityPermission")
			{
				throw new SecurityException(
					   "\n\nSecurity exception.\n\n"
					+ "Please run the following:\n\n\tALTER ASSEMBLY "
					+ "[StairwayToSQLCLR-04-Security2_ExternalAccess] "
					+ "WITH PERMISSION_SET = EXTERNAL_ACCESS;\n"
					+ "\n\n");
			}

			throw;
		}
		catch (Exception ex)
		{
			if (_impersonationIdentity != null)
			{
				_impersonationIdentity.Undo();
			}
			throw;
		}
		finally
		{
			// make sure to clean up external resources!
			if (_dataReader != null && !_dataReader.IsClosed)
			{
				_dataReader.Close();
			}

			if (_sqlConnection.State != ConnectionState.Closed)
			{
				_sqlConnection.Close();
			}

			if (_impersonationIdentity != null)
			{
				_impersonationIdentity.Undo();
			}
		}

		return;
	}
}
