/**********************************************
 * CreateAssemblyCheck.cs
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 4: Security (EXTERNAL_ACCESS and UNSAFE Assemblies)
 * http://www.sqlservercentral.com/articles/Stairway+Series/112888/
 * 
 * Copyright (C) 2014 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

using System.Data.SqlTypes; // the Sql* types

public class SqlClrSecurity_CreateAssemblyCheck
{
	// static variables are not allowed in assemblies
	// set as SAFE or EXTERNAL_ACCESS
	private static string _SharedMemory = "";

	[Microsoft.SqlServer.Server.SqlFunction(IsDeterministic = false,
		Name = "StairwayToSQLCLR_04_SetSharedValue", IsPrecise = true)]
	public static SqlString SetSharedValue(SqlString ValueToSet)
	{
		string _temp = _SharedMemory;

		_SharedMemory = ValueToSet.Value;

		return _temp;
	}

	[Microsoft.SqlServer.Server.SqlFunction(IsDeterministic = false,
		Name = "StairwayToSQLCLR_04_GetSharedValue", IsPrecise = true)]		
	public static SqlString GetSharedValue()
	{
		return _SharedMemory;
	}
}
