/**********************************************
 * StairwayToSQLCLR-04-04-ExternalAccessTests.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 4: Security (EXTERNAL_ACCESS and UNSAFE Assemblies)
 * http://www.sqlservercentral.com/articles/Stairway+Series/112888/
 * 
 * Copyright (C) 2014 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

USE [StairwayToSQLCLR];
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO

-- Make sure changes made farther down are not currently in place if starting over
-- DB should be TRUSTWORTHY OFF by default, but set just in case
REVERT;
GO
ALTER DATABASE [StairwayToSQLCLR] SET TRUSTWORTHY OFF;
GO

----------------------------------------------------------

-- straight T-SQL call directly to the function; this should not error
SELECT * FROM dbo.WhoAmI();

------

-- Internal / Context Connection
EXEC dbo.StairwayToSQLCLR_04_WhoAmI @ServerName = NULL, @Impersonate = 0, @Message = NULL;

-- Internal / Context Connection (with message output)
EXEC dbo.StairwayToSQLCLR_04_WhoAmI @ServerName = NULL, @Impersonate = 0, @Message = 'test';


----------------------------------------------------------

-- ALTER ASSEMBLY [StairwayToSQLCLR-04-Security2_ExternalAccess] WITH PERMISSION_SET = SAFE;

-- External / Regular connection
-- *** PLEASE NOTE: If you are using a named instance (i.e. ServerName\InstanceName vs ServerName)
--     you will probably need to replace all instances of '(local)' with '(local)\InstanceName' in
--     this script and in scripts 05-TrustworthyVsAsymmetricKeyTests and 08-PointsOfInterestTests.
--     For example:  '(local)\sqlexpress'
EXEC dbo.StairwayToSQLCLR_04_WhoAmI @ServerName = '(local)', @Impersonate = 0, @Message = NULL;
-- error: System.Security.SecurityException

ALTER ASSEMBLY [StairwayToSQLCLR-04-Security2_ExternalAccess] WITH PERMISSION_SET = EXTERNAL_ACCESS;
/*
Msg 10327, Level 14, State 1, Line 1
   ALTER ASSEMBLY for assembly 'StairwayToSQLCLR-04-Security2_ExternalAccess'
   failed because assembly 'StairwayToSQLCLR-04-Security2_ExternalAccess' is not
   authorized for PERMISSION_SET = EXTERNAL_ACCESS.  The assembly is authorized
   when either of the following is true: the database owner (DBO) has EXTERNAL
   ACCESS ASSEMBLY permission and the database has the TRUSTWORTHY database
   property on; or the assembly is signed with a certificate or an asymmetric
   key that has a corresponding login with EXTERNAL ACCESS ASSEMBLY permission.
*/


ALTER DATABASE [StairwayToSQLCLR] SET TRUSTWORTHY ON;


ALTER ASSEMBLY [StairwayToSQLCLR-04-Security2_ExternalAccess] WITH PERMISSION_SET = EXTERNAL_ACCESS;


-- External / Regular connection
EXEC dbo.StairwayToSQLCLR_04_WhoAmI @ServerName = '(local)', @Impersonate = 0, @Message = NULL;
-- same command as before the ALTER ASSEMBLY, but now it works
-- Pay attention to: PROGRAM_NAME(), @@SPID, ORIGINAL_LOGIN()

EXEC dbo.StairwayToSQLCLR_04_WhoAmI @ServerName = '', @Impersonate = 0, @Message = NULL;
EXEC dbo.StairwayToSQLCLR_04_WhoAmI @ServerName = '(local)', @Impersonate = 0, @Message = NULL;


-- External / Regular connection
EXEC dbo.StairwayToSQLCLR_04_WhoAmI @ServerName = '(local)', @Impersonate = 0, @Message = 'test';
-- same as prior example, but "Messages" shows 'test'

----------------------------------------------------------


-- External / Regular connection with Impersonation
EXEC dbo.StairwayToSQLCLR_04_WhoAmI @ServerName = '(local)', @Impersonate = 1, @Message = NULL;

-- External / Regular connection with Impersonation
EXEC dbo.StairwayToSQLCLR_04_WhoAmI @ServerName = '(local)', @Impersonate = 1, @Message = 'test';
-- error: Data access is not allowed in an impersonated context.

----------------------------------------------------------


-- Internal / Context Connection
EXEC dbo.StairwayToSQLCLR_04_WhoAmI @ServerName = NULL, @Impersonate = 1, @Message = NULL;
-- error: Data access is not allowed in an impersonated context.
-- cannot use Context Connection while impersonating


-- Run all 4 of the following queries together.
-- Pay attention to: PROGRAM_NAME(), @@SPID, ORIGINAL_LOGIN()
SELECT * FROM dbo.WhoAmI();
-- PROGRAM_NAME()		Microsoft SQL Server Management Studio - Query
-- @@SPID				56
-- ORIGINAL_LOGIN()		Dali\Solomon

EXEC dbo.StairwayToSQLCLR_04_WhoAmI @ServerName = NULL, @Impersonate = 0;
-- PROGRAM_NAME()		Microsoft SQL Server Management Studio - Query
-- @@SPID				56
-- ORIGINAL_LOGIN()		Dali\Solomon

EXEC dbo.StairwayToSQLCLR_04_WhoAmI @ServerName = N'(local)', @Impersonate = 0;
-- PROGRAM_NAME()		.Net SqlClient Data Provider
-- @@SPID				58
-- ORIGINAL_LOGIN()		Dali\SQLServer

EXEC dbo.StairwayToSQLCLR_04_WhoAmI @ServerName = N'(local)', @Impersonate = 1;
-- PROGRAM_NAME()		.Net SqlClient Data Provider
-- @@SPID				59
-- ORIGINAL_LOGIN()		Dali\Solomon


-------------------------------------------------------------------------------------
-------------------------------------------------------------------------------------
EXECUTE AS USER = 'TestUser';

-- Pay attention to: ORIGINAL_LOGIN() and SESSION_USER
SELECT * FROM dbo.WhoAmI();


-- Internal / Context Connection
EXEC dbo.StairwayToSQLCLR_04_WhoAmI @ServerName = NULL, @Impersonate = 0, @Message = NULL;


-- External / Regular connection (no Impersonation)
-- Pay attention to: ORIGINAL_LOGIN() and SESSION_USER
EXEC dbo.StairwayToSQLCLR_04_WhoAmI @ServerName = '(local)', @Impersonate = 0, @Message = NULL;


-- External / Regular connection with Impersonation
EXEC dbo.StairwayToSQLCLR_04_WhoAmI @ServerName = '(local)', @Impersonate = 2, @Message = NULL;
-- error: Object reference not set to an instance of an object.
-- no Windows SID to get from SqlContext.WindowsIdentity

REVERT;
-------------------------------------
