/**********************************************
 * StairwayToSQLCLR-03-09-DisableCLR.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 3: Security (General and SAFE Assemblies)
 * http://www.sqlservercentral.com/articles/Stairway+Series/109905/
 * 
 * Copyright (C) 2014 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

USE [master];
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO

IF (EXISTS(
	-- Highlight below query and F5 / Ctrl-E to see details
	SELECT *
	FROM sys.configurations
	WHERE configuration_id = 1562 -- name = "clr enabled"
	-- Highlight above query and F5 / Ctrl-E to see details
	AND value_in_use = 1
	))
BEGIN
	PRINT 'Disabling CLR...'
	EXEC sp_configure 'clr enabled', 0

	-- Uncomment the WITH OVERRIDE if you get the
	-- "ad hoc changes are not allowed" error
	PRINT 'Reconfiguring...'
	RECONFIGURE --WITH OVERRIDE
	PRINT 'Done.'
END
ELSE
BEGIN
	PRINT 'CLR already Disabled.'
END
GO
