/**********************************************
 * StairwayToSQLCLR-03-08-RemoveExampleDB.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 3: Security (General and SAFE Assemblies)
 * http://www.sqlservercentral.com/articles/Stairway+Series/109905/
 * 
 * Copyright (C) 2014 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

USE [master];
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO

BEGIN TRY

	IF (DB_ID(N'StairwayToSQLCLR') IS NOT NULL)
	BEGIN
		PRINT 'Setting test DB to SINGLE_USER mode...';
		ALTER DATABASE [StairwayToSQLCLR] SET SINGLE_USER WITH ROLLBACK IMMEDIATE;

		PRINT 'Dropping test DB...';
		DROP DATABASE [StairwayToSQLCLR];

		PRINT 'Sample Database removed!';
	END;

	PRINT '--------------------'
	------------------------------

END TRY
BEGIN CATCH

	DECLARE @Message NVARCHAR(4000);
	SET @Message = ERROR_MESSAGE();

	RAISERROR(@Message, 16, 1);

END CATCH
GO
