/**********************************************
 * StairwayToSQLCLR-03-07-OwnershipChainTest.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 3: Security (General and SAFE Assemblies)
 * http://www.sqlservercentral.com/articles/Stairway+Series/109905/
 * 
 * Copyright (C) 2014 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

USE [StairwayToSQLCLR];
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO


----------------------------------------------------------
-- For the first set of tests we will change our security
-- context to that of a user that has permissions to SELECT
-- from the Table and EXECUTE both Stored Procedures via
-- the GRANTs on those objects given to the PUBLIC role.

EXECUTE AS USER = 'TestUser';
SELECT SESSION_USER AS [SessionUser];


SELECT * FROM [StairwayToSQLCLR].dbo.StairwayToSQLCLR_03;
-- no rows yet, but also no errors.


-- No direct INSERT permissions have been granted, but try anyway.

INSERT INTO [StairwayToSQLCLR].dbo.StairwayToSQLCLR_03 (MessageText)
	VALUES (N'test attempt 1');
-- error:
/*
Msg 229, Level 14, State 5, Line 1
The INSERT permission was denied on the object 'StairwayToSQLCLR_03', database
	'StairwayToSQLCLR', schema 'dbo'.
*/


-- Attempt to EXEC the Proc, not giving it anything to INSERT, but just to
-- make sure we have EXECUTE permission.

EXEC [StairwayToSQLCLR].dbo.StairwayToSQLCLR_03_InsertRowTSQL;
-- "Nothing to INSERT." in Messages tab


-- Execute the Proc again, this time giving it something to INSERT.

EXEC [StairwayToSQLCLR].dbo.StairwayToSQLCLR_03_InsertRowTSQL @Message = N'test attempt 2';
-- no error


-- SESSION_USER shows that we are indeed running as [TestUser].
SELECT SESSION_USER AS [SessionUser];

SELECT * FROM [StairwayToSQLCLR].dbo.StairwayToSQLCLR_03;
-- At least one row (and with "StairwayToSQLCLR_03_InsertRowTSQL" as the [InsertSource])
-- should be returned.  Ownership Chaining granted us implicit permission to the objects
-- referenced within the Stored Procedure, as long as they have the same owner as the
-- Stored Procedure, and in this case they do.


----------------------------------------------------------

-- Attempt to EXEC the Proc, not giving it anything to INSERT, but just to
-- make sure we have EXECUTE permission.

EXEC [StairwayToSQLCLR].dbo.StairwayToSQLCLR_03_InsertRowCLR;
-- "Nothing to INSERT." in Messages tab


-- Execute the Proc again, this time giving it something to INSERT.

EXEC [StairwayToSQLCLR].dbo.StairwayToSQLCLR_03_InsertRowCLR @Message = N'test attempt 3';
/*
Msg 6522, Level 16, State 1, Procedure StairwayToSQLCLR_03_InsertRowCLR, Line 0
A .NET Framework error occurred during execution of user-defined routine or
	aggregate "StairwayToSQLCLR_03_InsertRowCLR": 
System.Data.SqlClient.SqlException: The INSERT permission was denied on the
	object 'StairwayToSQLCLR_03', database 'StairwayToSQLCLR', schema 'dbo'.
*/


----------------------------------------------------------
-- Revert the security context change done at the top of this script
-- so we can test as the owner of the Table.
REVERT;
SELECT SESSION_USER AS [SessionUser];


-- Execute the Proc again, this time giving it something to INSERT.

EXEC [StairwayToSQLCLR].dbo.StairwayToSQLCLR_03_InsertRowCLR @Message = N'test attempt 4';
-- no error


-- SESSION_USER shows that we are running as our expected user/login.
SELECT SESSION_USER AS [SessionUser];

SELECT * FROM [StairwayToSQLCLR].dbo.StairwayToSQLCLR_03;
-- At least one row returned with "test attempt 4" as the [MessageText] and
-- "Ad-hoc or Dynamic SQL" as the [InsertSource]


-------------------------------------
