/**********************************************
 * StairwayToSQLCLR-03-05-CreateObjectsForNextTwoTests.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 3: Security (General and SAFE Assemblies)
 * http://www.sqlservercentral.com/articles/Stairway+Series/109905/
 * 
 * Copyright (C) 2014 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

USE [StairwayToSQLCLR];
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO


----------------------------------------------------------

-- Clean up prior install (all except table: [StairwayToSQLCLR_03])
IF (OBJECT_ID(N'dbo.StairwayToSQLCLR_03_InsertRowTSQL') IS NOT NULL)
BEGIN
	PRINT 'Dropping Stored Procedure [StairwayToSQLCLR_03_InsertRowTSQL] ...';
	DROP PROCEDURE [dbo].[StairwayToSQLCLR_03_InsertRowTSQL];
	PRINT 'Done.';
	PRINT '';
END;

IF (OBJECT_ID(N'dbo.StairwayToSQLCLR_03_InsertRowCLR') IS NOT NULL)
BEGIN
	PRINT 'Dropping Stored Procedure [StairwayToSQLCLR_03_InsertRowCLR] ...';
	DROP PROCEDURE [dbo].[StairwayToSQLCLR_03_InsertRowCLR];
	PRINT 'Done.';
	PRINT '';
END;

IF (OBJECT_ID(N'dbo.WhoAmI') IS NOT NULL)
BEGIN
	PRINT 'Dropping Function [WhoAmI] ...';
	DROP FUNCTION [dbo].[WhoAmI];
	PRINT 'Done.';
	PRINT '';
END;

IF (OBJECT_ID(N'StairwayToSQLCLR_03_WhoAmI') IS NOT NULL)
BEGIN
	PRINT 'Dropping Stored Procedure [StairwayToSQLCLR_03_WhoAmI]  ...';
	DROP PROCEDURE [dbo].[StairwayToSQLCLR_03_WhoAmI];
	PRINT 'Done.';
	PRINT '';
END;

IF (ASSEMBLYPROPERTY(N'StairwayToSQLCLR-03-Security', 'SimpleName') IS NOT NULL)
BEGIN
	PRINT 'Dropping Assembly [StairwayToSQLCLR-03-Security] ...';
	DROP ASSEMBLY [StairwayToSQLCLR-03-Security];
	PRINT 'Done.';
	PRINT '';
END;
GO

----------------------------------------------------------

-- Install Assembly and then Stored Procs and Functions
PRINT 'Creating Assembly [StairwayToSQLCLR-03-Security] ...';
CREATE ASSEMBLY [StairwayToSQLCLR-03-Security]
	AUTHORIZATION [dbo]
	FROM 'C:\TEMP\StairwayToSQLCLR\Level-03\Assemblies\StairwayToSQLCLR-03-Security.dll'
	WITH PERMISSION_SET = SAFE;
PRINT 'Done.';
PRINT '';


-- This proc is used in StairwayToSQLCLR-03-06-InternalDataAccessTest.sql
-- and again in Level 4.
PRINT 'Creating Stored Procedure [StairwayToSQLCLR_03_WhoAmI] ...';
EXEC('
CREATE PROCEDURE [dbo].[StairwayToSQLCLR_03_WhoAmI]
(
	@ServerName NVARCHAR(200) = NULL,
	@Impersonate TINYINT = 0,
	@Message NVARCHAR(4000) = NULL
)
AS EXTERNAL NAME [StairwayToSQLCLR-03-Security].[SqlClrSecurity].[WhoAmI]
');
PRINT 'Done.';
PRINT '';


-- This function is used in StairwayToSQLCLR-03-06-InternalDataAccessTest.sql
-- and again in Level 4.
PRINT 'Creating Function [WhoAmI] ...';
EXEC('
CREATE FUNCTION [dbo].[WhoAmI] ()
RETURNS TABLE
WITH SCHEMABINDING
AS RETURN
SELECT	@@SERVERNAME AS [@@SERVERNAME],
		DB_NAME() AS [DB_NAME()],
		DB_ID() AS [DB_ID()],
		''---'' AS [---],
		PROGRAM_NAME() AS [PROGRAM_NAME()],
		@@SPID AS [@@SPID],
		CONTEXT_INFO() AS [CONTEXT_INFO()],
		ORIGINAL_LOGIN() AS [ORIGINAL_LOGIN()],
		''----'' AS [----],
		SUSER_ID() AS [SUSER_ID()],
		SUSER_SID() AS [SUSER_SID()],
		SUSER_NAME() AS [SUSER_NAME()],
		SUSER_SNAME() AS [SUSER_SNAME()],
		SYSTEM_USER AS [SYSTEM_USER],
		''-----'' AS [-----],
		USER_ID() AS [USER_ID()],
		USER_SID() AS [USER_SID()],
		USER_NAME() AS [USER_NAME()], -- effectively same as CURRENT_USER and USER
		SESSION_USER AS [SESSION_USER]
');


----------------------------------------------------------

-- This table is only used in StairwayToSQLCLR-03-07-OwnershipChainTests.sql
-- DROP TABLE dbo.StairwayToSQLCLR_03;
IF (OBJECT_ID('dbo.StairwayToSQLCLR_03') IS NULL)
BEGIN
	PRINT 'Creating Table [StairwayToSQLCLR_03] ...';
	CREATE TABLE dbo.StairwayToSQLCLR_03
	(
		ID INT IDENTITY(1, 1) NOT NULL
			CONSTRAINT [PK_StairwayToSQLCLR_03] PRIMARY KEY CLUSTERED,
		MessageText NVARCHAR(4000) NOT NULL,
		InsertSource NVARCHAR(128) NOT NULL
			CONSTRAINT [DF_StairwayToSQLCLR_03_InsertSource]
			DEFAULT (COALESCE(OBJECT_NAME(@@PROCID), N'Ad-hoc or Dynamic SQL')),
		InsertTime DATETIME NOT NULL
			CONSTRAINT [DF_StairwayToSQLCLR_03_InsertTime] DEFAULT (GETDATE()),
		InsertUser SYSNAME NOT NULL
			CONSTRAINT [DF_StairwayToSQLCLR_03_InsertUser] DEFAULT (SESSION_USER)
	);
	PRINT 'Done.';
	PRINT '';
END


-- This proc is only used in StairwayToSQLCLR-03-07-OwnershipChainTests.sql
PRINT 'Creating Stored Procedure [StairwayToSQLCLR_03_InsertRowTSQL] ...';
EXEC('
CREATE PROCEDURE [dbo].[StairwayToSQLCLR_03_InsertRowTSQL]
(
	@Message NVARCHAR(4000) = NULL
)
AS
SET NOCOUNT ON;

IF (@Message IS NULL)
BEGIN
	PRINT ''Nothing to INSERT.'';
	RETURN;
END;

INSERT INTO dbo.StairwayToSQLCLR_03 (MessageText)
	VALUES (@Message);

RETURN;
');
PRINT 'Done.';
PRINT '';


-- This proc is only used in StairwayToSQLCLR-03-07-OwnershipChainTests.sql
PRINT 'Creating Stored Procedure [StairwayToSQLCLR_03_InsertRowCLR] ...';
EXEC('
CREATE PROCEDURE [dbo].[StairwayToSQLCLR_03_InsertRowCLR]
(
	@Message NVARCHAR(4000) = NULL
)
AS EXTERNAL NAME [StairwayToSQLCLR-03-Security].[SqlClrSecurity].[InsertRowCLR];
');
PRINT 'Done.';
PRINT '';


GO

----------------------------------------------------------

GRANT SELECT ON dbo.WhoAmI TO PUBLIC;

GRANT SELECT ON dbo.StairwayToSQLCLR_03 TO PUBLIC;

GRANT EXECUTE ON dbo.StairwayToSQLCLR_03_WhoAmI TO PUBLIC;

GRANT EXECUTE ON dbo.StairwayToSQLCLR_03_InsertRowTSQL TO PUBLIC;

GRANT EXECUTE ON dbo.StairwayToSQLCLR_03_InsertRowCLR TO PUBLIC;
GO
