/**********************************************
 * StairwayToSQLCLR-03-03-CreateAssemblyCheckTest.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 3: Security (General and SAFE Assemblies)
 * http://www.sqlservercentral.com/articles/Stairway+Series/109905/
 * 
 * Copyright (C) 2014 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

USE [StairwayToSQLCLR];
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO


----------------------------------------------------------
-- The following two CREATE ASSEMBLY statements will fail without even
-- checking the code inside the Assembly due to the database not allowing
-- any Assemblies to be set to UNSAFE or even EXTERNAL_ACCESS. This is
-- because neither of the two conditions required for allowing Assemblies
-- to be set to UNSAFE or EXTERNAL_ACCESS have been met, and that is
-- good as we (currently) only want to allow SAFE Assemblies.


CREATE ASSEMBLY [StairwayToSQLCLR-03-Security_CreateAssemblyCheck]
	AUTHORIZATION [dbo]
	FROM 'C:\TEMP\StairwayToSQLCLR\Level-03\Assemblies\StairwayToSQLCLR-03-Security_CreateAssemblyCheck.dll'
	WITH PERMISSION_SET = UNSAFE;
/*
Msg 10327, Level 14, State 1, Line 1
CREATE ASSEMBLY for assembly 'StairwayToSQLCLR-03-Security_CreateAssemblyCheck' failed because
   assembly 'StairwayToSQLCLR-03-Security_CreateAssemblyCheck' is not authorized for
   PERMISSION_SET = UNSAFE.  The assembly is authorized when either of the following is true:
   the database owner (DBO) has UNSAFE ASSEMBLY permission and the database has the TRUSTWORTHY
   database property on; or the assembly is signed with a certificate or an asymmetric key that
   has a corresponding login with UNSAFE ASSEMBLY permission.
*/


CREATE ASSEMBLY [StairwayToSQLCLR-03-Security_CreateAssemblyCheck]
	AUTHORIZATION [dbo]
	FROM 'C:\TEMP\StairwayToSQLCLR\Level-03\Assemblies\StairwayToSQLCLR-03-Security_CreateAssemblyCheck.dll'
	WITH PERMISSION_SET = EXTERNAL_ACCESS;
/*
Msg 10327, Level 14, State 1, Line 2
CREATE ASSEMBLY for assembly 'StairwayToSQLCLR-03-Security_CreateAssemblyCheck' failed because
	assembly 'StairwayToSQLCLR-03-Security_CreateAssemblyCheck' is not authorized for
	PERMISSION_SET = EXTERNAL_ACCESS.  The assembly is authorized when either of the following
	is true: the database owner (DBO) has EXTERNAL ACCESS ASSEMBLY permission and the database
	has the TRUSTWORTHY database property on; or the assembly is signed with a certificate or
	an asymmetric key that has a corresponding login with EXTERNAL ACCESS ASSEMBLY permission.
*/

-------------------------------
-- The following CREATE ASSEMBLY statement fails, but this time it does check the code
-- inside of the Assembly and finds something that violates one of the restrictions. In this
-- case it states the exact violation.


CREATE ASSEMBLY [StairwayToSQLCLR-03-Security_CreateAssemblyCheck]
	AUTHORIZATION [dbo]
	FROM 'C:\TEMP\StairwayToSQLCLR\Level-03\Assemblies\StairwayToSQLCLR-03-Security_CreateAssemblyCheck.dll'
	WITH PERMISSION_SET = SAFE;
/*
Msg 6212, Level 16, State 1, Line 1
CREATE ASSEMBLY failed because method 'SetSharedValue' on type 'SqlClrSecurityCreateAssembly'
   in safe assembly 'StairwayToSQLCLR-03-Security_CreateAssemblyCheck' is storing to a static
   field. Storing to a static field is not allowed in safe assemblies.
*/



