/**********************************************
 * StairwayToSQLCLR-03-02-CreateDatabase.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 3: Security (General and SAFE Assemblies)
 * http://www.sqlservercentral.com/articles/Stairway+Series/109905/
 * 
 * Copyright (C) 2014 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

USE [master];
SET ANSI_NULLS ON;
SET QUOTED_IDENTIFIER ON;
SET NOCOUNT ON;
GO
------------------------------
IF (DB_ID(N'StairwayToSQLCLR') IS NULL)
BEGIN
	PRINT 'Creating test DB...';
	CREATE DATABASE [StairwayToSQLCLR];
END;
ELSE
BEGIN
	PRINT 'Test DB [StairwayToSQLCLR] already exists...';
END;


IF (EXISTS(
			SELECT	*
			FROM	sys.databases sd
			WHERE	sd.[name] = N'StairwayToSQLCLR'
			AND		(
						sd.recovery_model <> 3
					OR	sd.is_broker_enabled = 1
					)
			)
	)
BEGIN
	PRINT 'Altering test DB...';
	ALTER DATABASE [StairwayToSQLCLR] SET RECOVERY SIMPLE, DISABLE_BROKER WITH ROLLBACK IMMEDIATE;
END;

PRINT '--------------------';
------------------------------

IF (NOT EXISTS (
				SELECT	*
				FROM	[StairwayToSQLCLR].sys.database_principals dp
				WHERE	dp.name = N'TestUser'
			)
	)
BEGIN
	PRINT '';
	PRINT 'Creating User: [TestUser] ...';

	-- This User is only used in StairwayToSQLCLR-03-07-OwnershipChainTests.sql
	-- to show how SQLCLR objects handle implied permissions on objects referenced
	-- within them.
	EXEC(N'USE [StairwayToSQLCLR];
	       CREATE USER [TestUser] WITHOUT LOGIN WITH DEFAULT_SCHEMA=[dbo];');
END;
ELSE
BEGIN
	PRINT '';
	PRINT 'User [TestUser] already exists in [StairwayToSQLCLR]; skipping';
END;

PRINT '--------------------';
------------------------------
GO
