/**********************************************
 * StairwayToSQLCLR-03-01-EnableCLR.sql
 * 
 * Example Code for
 * Stairway to SQLCLR - Level 3: Security (General and SAFE Assemblies)
 * http://www.sqlservercentral.com/articles/Stairway+Series/109905/
 * 
 * Copyright (C) 2014 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

IF (EXISTS(
	-- Highlight below query and F5 / Ctrl-E to see details
	SELECT *
	FROM sys.configurations
	WHERE configuration_id = 1562 -- name = "clr enabled"
	-- Highlight above query and F5 / Ctrl-E to see details
	AND value_in_use = 0
	))
BEGIN
	PRINT 'Enabling CLR...'
	EXEC sp_configure 'clr enabled', 1

	-- Uncomment the WITH OVERRIDE if you get the
	-- "ad hoc changes are not allowed" error
	PRINT 'Reconfiguring...'
	RECONFIGURE --WITH OVERRIDE
	PRINT 'Done.'
END
ELSE
BEGIN
	PRINT 'CLR already enabled.'
END
GO
