/**********************************************
 * Example Code for
 * Stairway to SQLCLR - Level 3: Security (General and SAFE Assemblies)
 * http://www.sqlservercentral.com/articles/Stairway+Series/109905/
 * 
 * Copyright (C) 2014 Solomon Rutzky. All Rights Reserved.
 * 
 **********************************************/

using System; // contains types (String / Int64 / Guid), Exception, and ArgumentException
using System.Data.SqlTypes; // contains the Sql* types for input / output params

public class SqlClrSecurityCreateAssembly
{
	// static variables are not allowed in assemblies
	// set as SAFE or EXTERNAL_ACCESS
	private static string _SharedMemory = "";

	[Microsoft.SqlServer.Server.SqlFunction(IsDeterministic = false,
		Name = "StairwayToSQLCLR_03_SetSharedValue", IsPrecise = true)]
	public static SqlString SetSharedValue(SqlString ValueToSet)
	{
		string _temp = _SharedMemory;

		_SharedMemory = ValueToSet.Value;

		return _temp;
	}

	[Microsoft.SqlServer.Server.SqlFunction(IsDeterministic = false,
		Name = "StairwayToSQLCLR_03_GetSharedValue", IsPrecise = true)]		
	public static SqlString GetSharedValue()
	{
		return _SharedMemory;
	}
}
