/*
Samuel Vanga
08/28/2015
Setup.sql creates a new database, SSISPatterns with a staging table in it.
Used for article "SSIS Design Pattern - Staging Fixed Width Flat Files"
*/

USE master;
GO
IF EXISTS ( SELECT  *
            FROM    sys.sysdatabases AS s
            WHERE   s.name = 'SSISPatterns' )
    PRINT 'Database SSISPatterns already exists.';
ELSE
    BEGIN
        PRINT 'Creating SSISPatterns Database...';
        CREATE DATABASE SSISPatterns;
        PRINT 'Database SSISPatterns created successfuly.';
    END;
GO
USE SSISPatterns;
GO
IF EXISTS ( SELECT  *
            FROM    sys.tables AS t
            WHERE   t.name = 'stgDepartment' )
    DROP TABLE dbo.StgDepartment;
GO
CREATE TABLE dbo.StgDepartment
    (
      DepartmentID INT NULL ,
      Name VARCHAR(50) NULL ,
      GroupName VARCHAR(50) NULL ,
      ModifiedDate DATETIME NULL
    );