# ---------------------------------------------------------------------------
### <Script>
### <Author>
### Chad Miller 
### </Author>
### <Description>
### Writes volume/disk information to SQL database table
### </Description>
### <Usage>
### Write-VolToDb "Z002\sql2k8" "dbautility" "vol_space"
### powershell -command "& {C:\WINDOWS\system32\Script\Write-VolToDb.ps1 '[SRVR]' 'dbautility'}"
### </Usage>
### </Script>
# ---------------------------------------------------------------------------
param($destServer, $destDb)

#######################
function Get-SqlData
{
    param([string]$serverName=$(throw 'serverName is required.'), [string]$databaseName=$(throw 'databaseName is required.'),
          [string]$query=$(throw 'query is required.'))
 
    Write-Verbose "Get-SqlData serverName:$serverName databaseName:$databaseName query:$query"
 
    $connString = "Server=$serverName;Database=$databaseName;Integrated Security=SSPI;"
    $da = New-Object "System.Data.SqlClient.SqlDataAdapter" ($query,$connString)
    $dt = New-Object "System.Data.DataTable"
    [void]$da.fill($dt)
    $dt
 
} #Get-SqlData

#######################
function Get-Vol
{
    param($computerName)

    Get-WmiObject -computername "$ComputerName" Win32_Volume -filter "DriveType=3" | 
    foreach { add-member -in $_ -membertype noteproperty UsageDT $((Get-Date).ToString("yyyy-MM-dd"))
              add-member -in $_ -membertype noteproperty SizeGB $([math]::round(($_.Capacity/1GB),2))
              add-member -in $_ -membertype noteproperty FreeGB $([math]::round(($_.FreeSpace/1GB),2))
              add-member -in $_ -membertype noteproperty PercentFree $([math]::round((([float]$_.FreeSpace/[float]$_.Capacity) * 100),2)) -passThru} |
    select UsageDT, SystemName, Name, Label, SizeGB, FreeGB, PercentFree

}# Get-Vol

#######################
## The Out-DataTable function Adapted from http://thepowershellguy.com/blogs/posh/archive/2007/01/21/powershell-gui-scripblock-monitor-script.aspx 
#######################
function Out-DataTable 
{
    param($Properties="*")
    Begin
    {
        $dt = new-object Data.datatable  
        $First = $true 
    }
    Process
    {
        $DR = $DT.NewRow()  
        foreach ($item in $_ |  Get-Member -type *Property $Properties ) {  
          $name = $item.Name
          if ($first) {  
            $Col =  new-object Data.DataColumn  
            $Col.ColumnName = $name
            $DT.Columns.Add($Col)
          }  
            $DR.Item($name) = $_.$name  
        }  
        $DT.Rows.Add($DR)  
        $First = $false  
    }
    End
    {
        return @(,($dt))
    }

}# Out-DataTable 

#######################
function Write-DataTableToDatabase
{ 
    param($destServer,$destDb,$destTbl,$dt)

    $connectionString = "Data Source=$destServer;Integrated Security=true;Initial Catalog=$destdb;"
    $bulkCopy = new-object ("Data.SqlClient.SqlBulkCopy") $connectionString
    $bulkCopy.DestinationTableName = "$destTbl"
    $bulkCopy.WriteToServer($dt)

}# Write-DataTableToDatabase

#######################
Get-SqlData $destServer $destDb  "SELECT server_name FROM server_space_lku" |
foreach {
            #Get just the server name portion if instance name is included
            $computerName = $_.server_name -replace "\\.*",""
            $dt = Get-Vol $computerName | Out-DataTable
            Write-DataTableToDatabase $destServer $destDb 'vol_space' $dt
        }
