USE Organization
GO


IF EXISTS (SELECT * FROM sysobjects WHERE name = 'GetCustomers_2' AND type = 'P')
   DROP PROCEDURE dbo.GetCustomers_2
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


CREATE PROCEDURE dbo.GetCustomers_2
AS
BEGIN

    SET NOCOUNT ON;


    
    SELECT  CustomerID,
            CustomerName,
            CASE
                WHEN ParentCustomerID = -1 THEN NULL
                ELSE ParentCustomerID
            END AS ParentCustomerID,
            Node,
            NULL AS Page
    INTO    #R
    FROM    Customer
    WHERE   HierarchyLevel > 0

    

    -- ::::::::::::::::::::::::::::::::::::::::::::::::::::::
    --  Set page number for top-level nodes
    -- ::::::::::::::::::::::::::::::::::::::::::::::::::::::    
    ;WITH I AS
    (
        SELECT  CustomerID,
                (ROW_NUMBER() OVER (ORDER BY CustomerName))/100 + 1 AS Page
        FROM    #R
        WHERE   ParentCustomerID IS NULL
    )
    UPDATE  #R
    SET     Page = I.Page
    FROM    #R INNER JOIN I ON #R.CustomerID = I.CustomerID
    
    
    -- ::::::::::::::::::::::::::::::::::::::::::::::::::::::
    --  Set decendants' page number to be the same as their first-level ancestors
    -- ::::::::::::::::::::::::::::::::::::::::::::::::::::::
    
    -- the Page's created above
    SELECT  CustomerID AS TopAncestorId,
            Node AS TopAncestorNode,
            Page
    INTO    #T
    FROM    #R
    WHERE   Page IS NOT NULL
    
    
    UPDATE  R
    SET     Page = T.Page
    FROM    #R R
            INNER JOIN #T T ON R.Node.GetAncestor(R.Node.GetLevel() - 1) = TopAncestorNode
    WHERE   R.Page IS NULL
    
    
    -- ::::::::::::::::::::::::::::::::::::::::::::::::::::::
    --  Return
    -- ::::::::::::::::::::::::::::::::::::::::::::::::::::::
    SELECT  *
    FROM    #R
    
END