

-- :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
-- ETL from AdventureWorks
-- :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'Customer$' AND xtype = 'U')
   DROP TABLE Customer$
GO

SELECT  CustomerID,
        FirstName + ' ' + COALESCE(MiddleName, '') + ' ' + LastName + ' Inc.' AS CustomerName,
        ABS(CAST(NEWID() AS BINARY(6)) % 29484) AS ParentCustomerID
INTO    Customer$
FROM    AdventureWorks.Sales.vIndividualCustomer
GROUP BY CustomerID,
        FirstName,
        MiddleName,
        LastName


-- :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
-- add the root node
-- :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
INSERT  Customer$ VALUES (-1, 'root', NULL)

-- :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
-- point invalid ParentCustomerID to the newly added root node
-- :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
UPDATE  Customer$
SET     ParentCustomerID = -1   -- root node
WHERE   ParentCustomerID < 11000 -- 11000 is MIN CustomerID






-- :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
-- using CTE to create hierarchy (without HIERARCHYID)
-- Run time ~30 secs.
-- :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
/*
    ;WITH P(CustomerID, ParentCustomerID, HierarchyLevel)
    AS
    (
        SELECT  CustomerID, ParentCustomerID, 1 AS HierarchyLevel
        FROM    Customer$
        WHERE   ParentCustomerID IS NULL
    	
        UNION ALL
        
        SELECT  C.CustomerID, C.ParentCustomerID, HierarchyLevel + 1
        FROM    Customer$ AS C
                INNER JOIN P ON C.ParentCustomerID = P.CustomerID
    )
    SELECT  *
    FROM    P
*/


-- :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
-- using CTE to create hierarchy (with HIERARCHYID)
-- Run time ~30 secs.
-- :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
IF EXISTS (SELECT * FROM sysobjects WHERE name = 'Customer' AND xtype = 'U')
   DROP TABLE Customer
GO

;WITH P(CustomerID, CustomerName, ParentCustomerID, Node)
AS
(
    SELECT  CustomerID,
            CustomerName,
            ParentCustomerID,
            HIERARCHYID::GetRoot() AS Node
    FROM    Customer$
    WHERE   ParentCustomerID IS NULL
	
    UNION ALL
    
    SELECT  C.CustomerID,
            C.CustomerName,
            C.ParentCustomerID,
            CAST(P.Node.ToString() + CAST(ROW_NUMBER() OVER (PARTITION BY C.ParentCustomerID ORDER BY C.CustomerID) AS VARCHAR(30)) + '/' AS HIERARCHYID)
    FROM    Customer$ AS C
            INNER JOIN P ON C.ParentCustomerID = P.CustomerID
)
SELECT  *
INTO    Customer
FROM    P

-- Add PK
ALTER TABLE Customer
ALTER COLUMN CustomerID INT NOT NULL

ALTER TABLE Customer
ADD CONSTRAINT PK_Customer PRIMARY KEY CLUSTERED (CustomerID ASC)

-- Add computed field for BFS index
ALTER TABLE Customer
ADD HierarchyLevel AS Node.GetLevel() 

-- Add breadth-first index
CREATE UNIQUE INDEX IX_Customer_BFS 
ON Customer(HierarchyLevel, Node)

-- Add depth-first index
CREATE UNIQUE INDEX IX_SiebelAccount_DFS 
ON Customer(Node)


/*
    -- Add parent node
    ALTER TABLE Employee
    ADD ParentNode AS Node.GetAncestor(1) PERSISTED
    REFERENCES Employee(Node)
*/