﻿using System;
using System.Data;
using System.Data.SqlClient;

namespace SchemaToDataSetPart2
{
    class SchemaTest
    {
        public void BuildDatabaseFromSchema()
        {
            // Create a connection to the data set
            SqlConnection conn = new SqlConnection();
            conn.ConnectionString = "Data Source=(local);Initial Catalog=testDBExamples;Integrated Security=True";
            conn.Open();

            // Retrieve the schema information for the tables, columns and indexes.
            DataTable tableNames = conn.GetSchema("Tables");
            DataTable cols = conn.GetSchema("Columns");
            DataTable ixcols = conn.GetSchema("IndexColumns");

            DataSet testData = new DataSet();   // This will be the resulting data set.

            foreach (DataRow tdr in tableNames.Rows)  // Create the tables
            {
                string tName = tdr["TABLE_NAME"].ToString();
                if (tName.Length >= 3 && tName.Substring(0, 3) == "sys")  // Skip system tables.
                    continue;

                testData.Tables.Add(tName);   // Create the table and add it to the data set.

                DataRow[] tableCols = cols.Select("TABLE_NAME = '" + tName + "'");  // Select the columns for the current table

                foreach (DataRow cdr in tableCols)   // For the columns of this table
                {
                    string cName = cdr["COLUMN_NAME"].ToString();
                    testData.Tables[tName].Columns.Add(cName);   // Add the column to the collection
                    switch (cdr["DATA_TYPE"].ToString())  // Set the data type for the column.
                    {
                        case "varchar":
                            testData.Tables[tName].Columns[cName].DataType = typeof(string);
                            testData.Tables[tName].Columns[cName].MaxLength = Convert.ToInt32(cdr["CHARACTER_MAXIMUM_LENGTH"]);
                            break;
                        case "int":
                            testData.Tables[tName].Columns[cName].DataType = typeof(int);
                            break;
                        case "decimal":
                            testData.Tables[tName].Columns[cName].DataType = typeof(decimal);
                            break;
                        case "date":
                            testData.Tables[tName].Columns[cName].DataType = typeof(DateTime);
                            break;
                        default:
                            // Handle data type not recognized
                            break;
                    }
                    if (cdr["IS_NULLABLE"].ToString() == "YES")  // Allow NULL?
                        testData.Tables[tName].Columns[cName].AllowDBNull = true;
                    else
                        testData.Tables[tName].Columns[cName].AllowDBNull = false;

                }
                DataRow[] keyDefs = ixcols.Select("table_name = '" + tName + "'");  // Indexes (primary keys) for this table
                DataColumn[] keys = new DataColumn[keyDefs.Length];    // The PrimaryKey property is an array of DataColumn objects.
                for (int i = 0; i < keyDefs.Length; ++i)  // Build the list of keys. 
                {
                    keys[i] = testData.Tables[tName].Columns[keyDefs[i]["column_name"].ToString()];
                }
                testData.Tables[tName].PrimaryKey = keys;  // Assign the primary key for the table

            }  // foreach column name
            // Foreign keys:
            using (SqlCommand relCmd = new SqlCommand())   // Create a command to get the foreign key definitions.
            {
                relCmd.Connection = conn;
                relCmd.CommandText = "Select fkeys.name As keyName, parent.name As parentTable, pcol.name as parentColumn, ref.name As referencedTable, "
                + " rcol.name As referencedColumn, fkeys.delete_referential_action_desc, fkeys.update_referential_action_desc "
                + " from sys.foreign_keys fkeys Join sys.foreign_key_columns fccol On fkeys.object_id = fccol.constraint_object_id "
                + " Join sys.objects parent On fkeys.parent_object_id = parent.object_id "
                + " Join sys.objects ref On fkeys.referenced_object_id = ref.object_id "
                + " Join sys.columns pcol On fccol.parent_object_id = pcol.object_id And fccol.parent_column_id = pcol.column_id "
                + " Join sys.columns rcol On fccol.referenced_object_id = rcol.object_id And fccol.referenced_column_id = rcol.column_id";
                SqlDataReader relRdr = relCmd.ExecuteReader();

                // collect the table and column names from all rows for the relation
                string[] parentTbls = new string[5];  // Assumes there will not be more than 5 columns...
                string[] parentCols = new string[5];
                string[] refTbls = new string[5];
                string[] refCols = new string[5];
                string lastDeleteConstraint = "";
                string lastUpdateConstraint = "";
                int countCols = 0;
                string prevRelation = "";  // To check for more than one column contributing to the relationship.
                while (relRdr.Read())
                {
                    // use the table and column names to create the relation
                    string relName = relRdr["keyName"].ToString();
                    if (relName != prevRelation && prevRelation != "")  // Done collecting columns for previous relationship rows. (but not the first row)
                    {
                        DataColumn[] pCols = new DataColumn[countCols];  // Collection of parent columns
                        for (int ix = 0; ix < countCols; ++ix)
                            pCols[ix] = testData.Tables[parentTbls[ix]].Columns[parentCols[ix]];
                        DataColumn[] rCols = new DataColumn[countCols];  // Collection of referenced columbs
                        for (int ix = 0; ix < countCols; ++ix)
                            rCols[ix] = testData.Tables[refTbls[ix]].Columns[refCols[ix]];
                        DataRelation fk2 = new DataRelation(prevRelation, pCols, rCols);
                        testData.Relations.Add(fk2);  // 


                        ForeignKeyConstraint fkc2 = fk2.ChildKeyConstraint;  // get the child constraint to set up update and delete actions.

                        switch (relRdr["delete_referential_action_desc"].ToString())
                        {
                            case "NO_ACTION":
                                fkc2.DeleteRule = Rule.None;
                                break;
                            case "CASCADE":
                                fkc2.DeleteRule = Rule.Cascade;
                                break;
                            case "SET_NULL":
                                fkc2.DeleteRule = Rule.SetNull;
                                break;
                            case "SET_DEFAULT":
                                fkc2.DeleteRule = Rule.SetDefault;
                                break;
                        }
                        switch (relRdr["update_referential_action_desc"].ToString())
                        {
                            case "NO_ACTION":
                                fkc2.UpdateRule = Rule.None;
                                break;
                            case "CASCADE":
                                fkc2.UpdateRule = Rule.Cascade;
                                break;
                            case "SET_NULL":
                                fkc2.UpdateRule = Rule.SetNull;
                                break;
                            case "SET_DEFAULT":
                                fkc2.UpdateRule = Rule.SetDefault;
                                break;
                        }
                        countCols = 0;
                    }
                    parentTbls[countCols] = relRdr["parentTable"].ToString();
                    parentCols[countCols] = relRdr["parentColumn"].ToString();
                    refTbls[countCols] = relRdr["referencedTable"].ToString();
                    refCols[countCols] = relRdr["referencedColumn"].ToString();
                    lastDeleteConstraint = relRdr["delete_referential_action_desc"].ToString();
                    lastUpdateConstraint = relRdr["update_referential_action_desc"].ToString();
                    countCols += 1;
                    prevRelation = relName;
                }
                if (countCols > 0)
                {
                    // Add the last relationship (if any).
                    DataColumn[] pCols = new DataColumn[countCols];  // Collection of parent columns
                    for (int ix = 0; ix < countCols; ++ix)
                        pCols[ix] = testData.Tables[parentTbls[ix]].Columns[parentCols[ix]];
                    DataColumn[] rCols = new DataColumn[countCols];  // Collection of referenced columbs
                    for (int ix = 0; ix < countCols; ++ix)
                        rCols[ix] = testData.Tables[refTbls[ix]].Columns[refCols[ix]];
                    DataRelation fk2 = new DataRelation(prevRelation, pCols, rCols);
                    testData.Relations.Add(fk2);  // 


                    ForeignKeyConstraint fkc2 = fk2.ChildKeyConstraint;  // get the child constraint to set up update and delete actions.

                    switch (lastDeleteConstraint)
                    {
                        case "NO_ACTION":
                            fkc2.DeleteRule = Rule.None;
                            break;
                        case "CASCADE":
                            fkc2.DeleteRule = Rule.Cascade;
                            break;
                        case "SET_NULL":
                            fkc2.DeleteRule = Rule.SetNull;
                            break;
                        case "SET_DEFAULT":
                            fkc2.DeleteRule = Rule.SetDefault;
                            break;
                    }
                    switch (lastUpdateConstraint)
                    {
                        case "NO_ACTION":
                            fkc2.UpdateRule = Rule.None;
                            break;
                        case "CASCADE":
                            fkc2.UpdateRule = Rule.Cascade;
                            break;
                        case "SET_NULL":
                            fkc2.UpdateRule = Rule.SetNull;
                            break;
                        case "SET_DEFAULT":
                            fkc2.UpdateRule = Rule.SetDefault;
                            break;
                    }
                    countCols = 0;
                }

            }  // using SqlCommand...

            conn.Close();
        }
    }
}
