#region about the author
/*
 * 
 * eMail to raj_vasant@yahoo.com for any queries
 * 
 */
#endregion

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Configuration.Install;
using System.Data.SqlClient;
using System.IO;
using System.Windows.Forms;
using System.Reflection;

namespace MyDBInstallerClass
{
    [RunInstaller(true)]
    public partial class DBInstaller : Installer
    {
        #region Members
            private SqlConnection sqlCon;
        #endregion

        public DBInstaller()
        {
            InitializeComponent();
        }

        public override void Install(System.Collections.IDictionary stateSaver)
        {
            try
            {                
                string connStr = @"Data Source=(local);Integrated Security=SSPI;"; //initialize the connection string

                this.sqlCon = new SqlConnection(connStr); //create the connection object

                base.Install(stateSaver); //perform the installation tasks done by the base

                this.StartCreationProcess(); //start the SQL script reading and executing task
            }
            catch(Exception ex)
            {
                MessageBox.Show("ERROR: " + ex.Message); //throw ERROR messages
            }
            finally
            {
                if (this.sqlCon.State == System.Data.ConnectionState.Open) //close the connection of it is open
                    this.sqlCon.Close();
            }

        }

        /*
         * OVERRIDE this functions if you want to handle events after COMMIT or ROLLBACK of the Installation
         * You need to Explicity call this functions.
         * 
        public override void Commit(System.Collections.IDictionary savedState)
        {
            base.Commit(savedState);
        }

        public override void Rollback(System.Collections.IDictionary savedState)
        {
            base.Rollback(savedState);
        }
         * 
         */

        #region Private Functions
  
        private void StartCreationProcess()
        {
            try
            {
                this.sqlCon.Open(); //open the sql connection

                this.ExecuteSql("MyTestDB.sql"); //execute the SQL script

                //Execute as many SQL scripts on this connection.
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        private void ExecuteSql(string FileName)
        {
            try
            {
                Assembly asm = Assembly.GetExecutingAssembly(); //get the executing assembly details

                Stream strm = asm.GetManifestResourceStream(asm.GetName().Name + "." + FileName); //get the content of the sql script file as Stream object

                StreamReader reader = new StreamReader(strm); //create a  new StreamReader object

                string sql = reader.ReadToEnd();//Get the content of the SQL script file as string

                SqlCommand command = new SqlCommand(sql, this.sqlCon); //Create SQLCommand object

                command.ExecuteNonQuery(); //execute the query
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        #endregion
    }
}