﻿using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using QRCode4CS;

namespace QRCode4CSImageGenerator
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            Image canvas = new Bitmap(86, 86);
            Graphics artist = Graphics.FromImage(canvas);
            artist.Clear(Color.White);
            pictureBox1.Image = canvas;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            label3.Text = "";
            if (textBox1.Text.Length > 34)
            {
                textBox1.Text = textBox1.Text.Substring(0, 34);
                label3.Text = "String truncated to 34 character length";
            }
            label2.Text = textBox1.Text;

            pictureBox1.Image = CreateQRCode(textBox1.Text);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            //this.Text = textBox1.Text;
        }

        private void button3_Click(object sender, EventArgs e)
        {
            textBox1.Text = "";
            label2.Text = "";
            label3.Text = "";
            Image canvas = new Bitmap(86, 86);
            Graphics artist = Graphics.FromImage(canvas);
            artist.Clear(Color.White);
            pictureBox1.Image = canvas;
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }

        private void button4_Click(object sender, EventArgs e)
        {
            SaveFileDialog save = new SaveFileDialog();
            //save.Filter = "Bitmap files (*.bmp)|*.bmp|All files (*.*)|*.*";
            save.Filter = "Bitmap files (*.bmp)|*.bmp|JPG files (*.jpg)|*.jpg|GIF files (*.gif)|*.gif|PNG files (*.png)|*.png|All files (*.*)|*.*";
            save.FilterIndex = 4;
            save.RestoreDirectory = true;

            if (save.ShowDialog() == DialogResult.OK)
            {
                pictureBox1.Image.Save(save.FileName);
            }
        }

        public static Image CreateQRCode(string inputString)
        {
            QRCode4CS.QRCode qrcode = new QRCode4CS.QRCode(new QRCode4CS.Options(inputString));
            qrcode.Make();
            Image canvas = new Bitmap(86, 86);
            Graphics artist = Graphics.FromImage(canvas);
            artist.Clear(Color.White);
            for (int row = 0; row < qrcode.GetModuleCount(); row++)
            {
                for (int col = 0; col < qrcode.GetModuleCount(); col++)
                {
                    bool isDark = qrcode.IsDark(row, col);

                    if (isDark == true)
                    {
                        artist.FillRectangle(Brushes.Black, 2 * row + 10, 2 * col + 10, 2 * row + 15, 2 * col + 15);
                    }
                    else
                    {
                        artist.FillRectangle(Brushes.White, 2 * row + 10, 2 * col + 10, 2 * row + 15, 2 * col + 15);
                    }
                }
            }
            artist.FillRectangle(Brushes.White, 0, 76, 86, 86);
            artist.FillRectangle(Brushes.White, 76, 0, 86, 86);
            artist.Dispose();
            //return canvas;

            System.IO.MemoryStream ms = new System.IO.MemoryStream();
            canvas.Save(ms, System.Drawing.Imaging.ImageFormat.Jpeg);
            byte[] imagedata = null;
            imagedata = ms.GetBuffer();
            //return imagedata;

            ms = new MemoryStream(imagedata);
            Image returnImage = Image.FromStream(ms);
            return returnImage;
        }

        private void pictureBox1_Click(object sender, EventArgs e)
        {

        }
   }
}