﻿namespace CreateQRCodeReturnByteArray
{
    using System;
    using System.IO;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Data;
    using System.Drawing;
    using System.Linq;
    using System.Text;
    using System.Windows.Forms;
    using QRCode4CS;

    public class CreateQRCode
    {
        public static Byte[] ReturnByteArray(string inputString, string imageSize)
        {
            QRCode4CS.QRCode qrcode = new QRCode4CS.QRCode(new QRCode4CS.Options(inputString));
            qrcode.Make();
            byte[] imagedata = null;
            if (imageSize == "L")
            {
                Image canvas = new Bitmap(86, 86);
                Graphics artist = Graphics.FromImage(canvas);
                artist.Clear(Color.White);
                for (int row = 0; row < qrcode.GetModuleCount(); row++)
                {
                    for (int col = 0; col < qrcode.GetModuleCount(); col++)
                    {
                        bool isDark = qrcode.IsDark(row, col);

                        if (isDark == true)
                        {
                            artist.FillRectangle(Brushes.Black, 2 * row + 10, 2 * col + 10, 2 * row + 15, 2 * col + 15);
                        }
                        else
                        {
                            artist.FillRectangle(Brushes.White, 2 * row + 10, 2 * col + 10, 2 * row + 15, 2 * col + 15);
                        }
                    }
                }
                artist.FillRectangle(Brushes.White, 0, 76, 86, 86);
                artist.FillRectangle(Brushes.White, 76, 0, 86, 86);
                artist.Dispose();

                System.IO.MemoryStream ms = new System.IO.MemoryStream();
                canvas.Save(ms, System.Drawing.Imaging.ImageFormat.Png);

                imagedata = ms.GetBuffer();
            }
            else
            {
                Image canvas = new Bitmap(43, 43);
                Graphics artist = Graphics.FromImage(canvas);
                artist.Clear(Color.White);
                for (int row = 0; row < qrcode.GetModuleCount(); row++)
                {
                    for (int col = 0; col < qrcode.GetModuleCount(); col++)
                    {
                        bool isDark = qrcode.IsDark(row, col);

                        if (isDark == true)
                        {
                            artist.FillRectangle(Brushes.Black, row + 5, col + 5, row + 5, col + 5);
                        }
                        else
                        {
                            artist.FillRectangle(Brushes.White, row + 5, col + 5, row + 5, col + 5);
                        }
                    }
                }
                artist.FillRectangle(Brushes.White, 0, 38, 43, 43);
                artist.FillRectangle(Brushes.White, 38, 0, 43, 43);
                artist.Dispose();

                System.IO.MemoryStream ms = new System.IO.MemoryStream();
                canvas.Save(ms, System.Drawing.Imaging.ImageFormat.Png);
                imagedata = ms.GetBuffer();
            }
            return imagedata;
        }
    }
}