-- Precalculated closing balances example
-- (C) Johan hln, 2009

USE [PRECALCDB]
GO
/****** Object:  Table [dbo].[Dim_Time]    Script Date: 09/16/2009 09:53:14 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Dim_Time](
	[Date] [smalldatetime] NOT NULL,
	[Year_Key] [int] NOT NULL,
	[Month_Key] [int] NOT NULL,
	[Day_Key] [int] NOT NULL,
 CONSTRAINT [PK_Dim_Time] PRIMARY KEY CLUSTERED 
(
	[Day_Key] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY],
 CONSTRAINT [IX_Dim_Time] UNIQUE NONCLUSTERED 
(
	[Date] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Dim_Company]    Script Date: 09/16/2009 09:53:14 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Dim_Company](
	[Company_Key] [nvarchar](10) NOT NULL,
	[Company_Name] [nvarchar](50) NOT NULL,
 CONSTRAINT [PK_Dim_Company_1] PRIMARY KEY CLUSTERED 
(
	[Company_Key] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Dim_Account]    Script Date: 09/16/2009 09:53:14 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Dim_Account](
	[Account_Key] [nvarchar](10) NOT NULL,
	[Account_Name] [nvarchar](100) NOT NULL,
	[Group_Key] [nvarchar](10) NOT NULL,
	[Group_Name] [nvarchar](100) NOT NULL,
 CONSTRAINT [PK_Dim_Account] PRIMARY KEY CLUSTERED 
(
	[Account_Key] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Fact_GL_CB]    Script Date: 09/16/2009 09:53:14 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Fact_GL_CB](
	[Fact_GL_CB_ID] [int] IDENTITY(1,1) NOT NULL,
	[Amount_CB] [numeric](18, 2) NOT NULL,
	[Date] [smalldatetime] NOT NULL,
	[Day_Key] [int] NOT NULL,
	[Company_Key] [nvarchar](10) NOT NULL,
	[Account_Key] [nvarchar](10) NOT NULL,
 CONSTRAINT [PK_Fact_GL_CB] PRIMARY KEY CLUSTERED 
(
	[Fact_GL_CB_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Fact_GL]    Script Date: 09/16/2009 09:53:14 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Fact_GL](
	[Fact_GL_ID] [int] IDENTITY(1,1) NOT NULL,
	[Amount] [numeric](18, 2) NOT NULL,
	[Date] [smalldatetime] NOT NULL,
	[Day_Key] [int] NOT NULL,
	[Company_Key] [nvarchar](10) NOT NULL,
	[Account_Key] [nvarchar](10) NOT NULL,
 CONSTRAINT [PK_Fact_GL] PRIMARY KEY CLUSTERED 
(
	[Fact_GL_ID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  ForeignKey [FK_Fact_GL_Dim_Account]    Script Date: 09/16/2009 09:53:14 ******/
ALTER TABLE [dbo].[Fact_GL]  WITH CHECK ADD  CONSTRAINT [FK_Fact_GL_Dim_Account] FOREIGN KEY([Account_Key])
REFERENCES [dbo].[Dim_Account] ([Account_Key])
GO
ALTER TABLE [dbo].[Fact_GL] CHECK CONSTRAINT [FK_Fact_GL_Dim_Account]
GO
/****** Object:  ForeignKey [FK_Fact_GL_Dim_Company]    Script Date: 09/16/2009 09:53:14 ******/
ALTER TABLE [dbo].[Fact_GL]  WITH CHECK ADD  CONSTRAINT [FK_Fact_GL_Dim_Company] FOREIGN KEY([Company_Key])
REFERENCES [dbo].[Dim_Company] ([Company_Key])
GO
ALTER TABLE [dbo].[Fact_GL] CHECK CONSTRAINT [FK_Fact_GL_Dim_Company]
GO
/****** Object:  ForeignKey [FK_Fact_GL_Dim_Time]    Script Date: 09/16/2009 09:53:14 ******/
ALTER TABLE [dbo].[Fact_GL]  WITH CHECK ADD  CONSTRAINT [FK_Fact_GL_Dim_Time] FOREIGN KEY([Day_Key])
REFERENCES [dbo].[Dim_Time] ([Day_Key])
GO
ALTER TABLE [dbo].[Fact_GL] CHECK CONSTRAINT [FK_Fact_GL_Dim_Time]
GO
/****** Object:  ForeignKey [FK_Fact_GL_CB_Dim_Account]    Script Date: 09/16/2009 09:53:14 ******/
ALTER TABLE [dbo].[Fact_GL_CB]  WITH CHECK ADD  CONSTRAINT [FK_Fact_GL_CB_Dim_Account] FOREIGN KEY([Account_Key])
REFERENCES [dbo].[Dim_Account] ([Account_Key])
GO
ALTER TABLE [dbo].[Fact_GL_CB] CHECK CONSTRAINT [FK_Fact_GL_CB_Dim_Account]
GO
/****** Object:  ForeignKey [FK_Fact_GL_CB_Dim_Company]    Script Date: 09/16/2009 09:53:14 ******/
ALTER TABLE [dbo].[Fact_GL_CB]  WITH CHECK ADD  CONSTRAINT [FK_Fact_GL_CB_Dim_Company] FOREIGN KEY([Company_Key])
REFERENCES [dbo].[Dim_Company] ([Company_Key])
GO
ALTER TABLE [dbo].[Fact_GL_CB] CHECK CONSTRAINT [FK_Fact_GL_CB_Dim_Company]
GO
/****** Object:  ForeignKey [FK_Fact_GL_CB_Dim_Time]    Script Date: 09/16/2009 09:53:14 ******/
ALTER TABLE [dbo].[Fact_GL_CB]  WITH CHECK ADD  CONSTRAINT [FK_Fact_GL_CB_Dim_Time] FOREIGN KEY([Day_Key])
REFERENCES [dbo].[Dim_Time] ([Day_Key])
GO
ALTER TABLE [dbo].[Fact_GL_CB] CHECK CONSTRAINT [FK_Fact_GL_CB_Dim_Time]
GO
