USE [tempdb]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Hold_XP_MSVER]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[Hold_XP_MSVER](
	[IDX] [int] NULL,
	[C_NAME] [varchar](100) NULL,
	[INT_VALUE] [float] NULL,
	[C_VALUE] [varchar](128) NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[HoldforEachDB]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[HoldforEachDB](
	[Server] [nvarchar](128) NULL,
	[InstanceName] [nvarchar](128) NULL,
	[DatabaseName] [nvarchar](128) NOT NULL,
	[FileId] [smallint] NOT NULL,
	[GroupId] [smallint] NOT NULL,
	[Size] [real] NOT NULL,
	[MaxSize] [real] NOT NULL,
	[Growth] [real] NOT NULL,
	[FileStatus] [int] NOT NULL,
	[LogicalName] [nvarchar](128) NOT NULL,
	[Filename] [nvarchar](260) NOT NULL,
	[DatabaseStatus] [nvarchar](128) NULL,
	[Updateability] [nvarchar](128) NULL,
	[User_Access] [nvarchar](128) NULL,
	[Recovery] [nvarchar](128) NULL,
	[SpaceUsed(MB)] [real] NULL,
	[UsageType] [varchar](6) NULL,
	[Owner] [nvarchar](128) NULL,
	[CreateDate] [datetime] NULL,
	[CmptLevel] [tinyint] NULL,
	[DateChecked] [datetime] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[HoldDiskSpace]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[HoldDiskSpace](
	[Server] [nvarchar](128) NULL,
	[Drive] [char](1) NOT NULL,
	[Free(MB)] [int] NULL,
	[Total(MB)] [int] NULL,
	[Free(%)] [tinyint] NULL,
	[DateChecked] [datetime] NOT NULL CONSTRAINT [DF_HoldDiskSpace_Date Checked]  DEFAULT (getdate()),
PRIMARY KEY CLUSTERED 
(
	[Drive] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ErrorLog]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[ErrorLog](
	[Server] [nvarchar](128) NOT NULL,
	[dtMessage] [datetime] NULL,
	[SPID] [varchar](50) NULL,
	[vchMessage] [nvarchar](4000) NULL,
	[ID] [int] NULL
) ON [PRIMARY]
END
GO
