-- This SQL does not drop any tables
-- It only creates tables if they dont exist 

USE [SQL_Overview]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Jobs]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[Jobs](
	[Server] [nvarchar](128) NOT NULL,
	[job_id] [uniqueidentifier] NOT NULL,
	[name] [sysname] NOT NULL,
	[Job_Enabled] [tinyint] NOT NULL,
	[description] [nvarchar](512) NULL,
	[notify_level_eventlog] [int] NOT NULL,
	[notify_level_email] [int] NOT NULL,
	[notify_level_netsend] [int] NOT NULL,
	[notify_level_page] [int] NOT NULL,
	[notify_email_operator_id] [int] NOT NULL,
	[date_created] [datetime] NOT NULL,
	[date_modified] [datetime] NULL,
	[Category_Name] [sysname] NOT NULL,
	[next_run_date] [int] NULL,
	[next_run_time] [int] NULL,
	[last_run_outcome] [tinyint] NULL,
	[last_outcome_message] [nvarchar](1024) NULL,
	[last_run_date] [int] NULL,
	[last_run_time] [int] NULL,
	[last_run_duration] [int] NULL,
	[Notify_Operator] [sysname] NULL,
	[email_address] [nvarchar](100) NULL,
	[Package_run_date] [datetime] NULL
) ON [PRIMARY]
END
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Jobs]') AND name = N'IX_Jobs')
CREATE CLUSTERED INDEX [IX_Jobs] ON [dbo].[Jobs] 
(
	[Server] ASC,
	[job_id] ASC,
	[next_run_date] ASC,
	[next_run_time] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SSIS_ServerList]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[SSIS_ServerList](
	[Server] [varchar](128) NOT NULL,
	[Usage] [char](5) NULL,
	[Skip_SQL_Overview] [bit] NULL,
 CONSTRAINT [PK_SSIS_ServerList] PRIMARY KEY CLUSTERED 
(
	[Server] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Job_History]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[Job_History](
	[server] [nvarchar](128) NOT NULL,
	[name] [nvarchar](128) NOT NULL,
	[job_id] [uniqueidentifier] NOT NULL,
	[step_id] [int] NOT NULL,
	[sql_message_id] [int] NOT NULL,
	[sql_severity] [int] NOT NULL,
	[message] [nvarchar](1024) NULL,
	[run_status] [int] NOT NULL,
	[run_date] [int] NOT NULL,
	[run_time] [int] NOT NULL,
	[run_duration] [int] NOT NULL,
	[operator_id_emailed] [int] NOT NULL,
	[operator_id_netsent] [int] NOT NULL,
	[operator_id_paged] [int] NOT NULL,
	[retries_attempted] [int] NOT NULL,
	[Run_Start_datetime] [datetime] NULL,
	[Run_End_datetime] [datetime] NULL,
	[Run_StartDateOnly] [datetime] NULL,
	[Hours] [int] NULL,
	[Minutes] [int] NULL,
	[Seconds] [int] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Disk_Space]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[Disk_Space](
	[Server] [nvarchar](128) NOT NULL,
	[Drive] [varchar](3) NOT NULL,
	[Total(MB)] [int] NULL,
	[Free(MB)] [int] NULL,
	[Free(%)] [tinyint] NULL,
	[DateChecked] [datetime] NOT NULL,
 CONSTRAINT [PK_DiskSpace] PRIMARY KEY CLUSTERED 
(
	[Server] ASC,
	[Drive] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON, FILLFACTOR = 90) ON [PRIMARY]
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SQL_Servers]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[SQL_Servers](
	[Server] [nvarchar](128) NOT NULL,
	[ProductVersion] [varchar](100) NULL,
	[ProductLevel] [varchar](100) NULL,
	[ResourceLastUpdateDateTime] [varchar](100) NULL,
	[ResourceVersion] [varchar](100) NULL,
	[IsIntegratedSecurityOnly] [varchar](23) NULL,
	[EngineEdition] [varchar](18) NULL,
	[InstanceName] [varchar](100) NULL,
	[ComputerNamePhysicalNetBIOS] [nvarchar](128) NULL,
	[LicenseType] [varchar](100) NULL,
	[NumLicenses] [varchar](100) NULL,
	[BuildClrVersion] [varchar](100) NULL,
	[Collation] [varchar](100) NULL,
	[CollationID] [varchar](100) NULL,
	[ComparisonStyle] [varchar](100) NULL,
	[ProductEdition] [varchar](38) NULL,
	[IsClustered] [varchar](13) NULL,
	[IsFullTextInstalled] [varchar](26) NULL,
	[SqlCharSet] [varchar](100) NULL,
	[SqlCharSetName] [varchar](100) NULL,
	[SqlSortOrderID] [varchar](100) NULL,
	[SqlSortOrderName] [varchar](100) NULL,
	[WindowsVersion] [varchar](128) NULL,
	[ProcessorCount] [smallint] NULL,
	[ProcessorType] [varchar](128) NULL,
	[PhysicalMemory] [int] NULL,
	[FileDescription] [varchar](128) NULL,
	[Platform] [varchar](128) NULL,
	[InstanceLastStartDate] [datetime] NULL,
 CONSTRAINT [PK_SQL_Servers] PRIMARY KEY NONCLUSTERED 
(
	[Server] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SQL_Servers]') AND name = N'IX_SQL_Servers')
CREATE CLUSTERED INDEX [IX_SQL_Servers] ON [dbo].[SQL_Servers] 
(
	[Server] ASC,
	[InstanceName] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Backup_History]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[Backup_History](
	[Server] [nvarchar](128) NOT NULL,
	[logical_device_name] [nvarchar](128) NULL,
	[physical_device_name] [nvarchar](260) NULL,
	[expiration_date] [datetime] NULL,
	[name] [nvarchar](128) NULL,
	[description] [nvarchar](255) NULL,
	[user_name] [nvarchar](128) NULL,
	[backup_start_date] [datetime] NULL,
	[backup_finish_date] [datetime] NULL,
	[backup_type] [varchar](20) NULL,
	[backup_size] [numeric](20, 0) NULL,
	[database_name] [nvarchar](128) NULL,
	[Source_Server] [nvarchar](128) NULL,
	[recovery_model] [nvarchar](60) NULL
) ON [PRIMARY]
END
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Backup_History]') AND name = N'IX_Backup_History')
CREATE CLUSTERED INDEX [IX_Backup_History] ON [dbo].[Backup_History] 
(
	[Server] ASC,
	[database_name] ASC,
	[backup_finish_date] DESC,
	[backup_start_date] DESC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Database_Info]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[Database_Info](
	[Server] [nvarchar](128) NOT NULL,
	[InstanceName] [nvarchar](128) NULL,
	[DatabaseName] [nvarchar](128) NOT NULL,
	[LogicalName] [nvarchar](128) NOT NULL,
	[Owner] [nvarchar](128) NULL,
	[CreateDate] [datetime] NULL,
	[CmptLevel] [tinyint] NULL,
	[UsageType] [varchar](6) NULL,
	[Size(MB)] [real] NOT NULL,
	[SpaceUsed(MB)] [real] NULL,
	[MaxSize(MB)] [real] NULL,
	[NextAllocation (MB)] [real] NULL,
	[GrowthType] [varchar](12) NULL,
	[FileStatus] [int] NOT NULL,
	[Filename] [nvarchar](260) NOT NULL,
	[DatabaseStatus] [nvarchar](128) NULL,
	[Updateability] [nvarchar](128) NULL,
	[User_Access] [nvarchar](128) NULL,
	[Recovery] [nvarchar](128) NULL,
	[FileId] [smallint] NOT NULL,
	[GroupId] [smallint] NOT NULL,
	[DateChecked] [datetime] NULL
) ON [PRIMARY]
END
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Database_Info]') AND name = N'IX_Database_Info')
CREATE CLUSTERED INDEX [IX_Database_Info] ON [dbo].[Database_Info] 
(
	[Server] ASC,
	[InstanceName] ASC,
	[DatabaseName] ASC,
	[Filename] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ErrorLog]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[ErrorLog](
	[Server] [nvarchar](128) NOT NULL,
	[dtMessage] [datetime] NULL,
	[SPID] [varchar](50) NULL,
	[vchMessage] [nvarchar](4000) NULL,
	[ID] [int] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Database_Status]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[Database_Status](
	[Server] [nvarchar](128) NOT NULL,
	[InstanceName] [nvarchar](128) NULL,
	[DatabaseName] [nvarchar](128) NOT NULL,
	[DatabaseStatus] [nvarchar](128) NULL,
	[User_Access] [nvarchar](128) NULL,
	[Updatability] [nvarchar](128) NULL,
	[Recovery] [nvarchar](128) NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SSIS_Errors]') AND type in (N'U'))
BEGIN

CREATE TABLE [dbo].[SSIS_Errors](
       [Server] [varchar](128) NOT NULL,
       [TaskName] [varchar](128) NULL,
       [ErrorCode] [int] NULL,
       [ErrorDescription] [varchar](MAX) NULL
    ) ON [PRIMARY]
END
GO
