/* s01-Job Last Run Datetime */
-- Get Job Name
SET nocount ON 
DECLARE @JobName sysname 
 SELECT @JobName = [name] FROM msdb.dbo.sysjobs 
  WHERE Job_id =  CONVERT(uniqueidentifier, $(ESCAPE_NONE(JOBID)))
PRINT '>'+@JobName+'<'

-- Get the date of the last successful execution of this job
DECLARE @dtLastRun datetime
DECLARE @chLastRun CHAR(26)
SELECT TOP 1 @dtLastRun = 
       CAST(CAST(run_date AS CHAR(8)) + ' ' +      -- Convert run_date to DateTime data type
        STUFF(STUFF(                                  -- Insert : into Time
         RIGHT('000000' +                             -- Add leading Zeros
          CAST(run_time AS VARCHAR(6))  ,6)  , 3, 0, ':'), 6, 0, ':') AS datetime)     
  FROM msdb.dbo.sysjobs A, msdb.dbo.sysjobhistory B 
 WHERE A.job_id = B.job_id AND B.run_status = 1
   AND A.name = @JobName
 ORDER BY 1 DESC
SELECT 'Job Last Run Date', @dtLastRun 


IF  @dtLastRun IS NULL SET @dtLastRun = '1900-01-01'
SET @chLastRun = CONVERT(CHAR(26),@dtLastRun)
PRINT 'Job Last Run Date = ' + @chLastRun

DELETE FROM [rep].[SQL_Overview_Last_Run_Date]

INSERT INTO [rep].[SQL_Overview_Last_Run_Date]
           ([LastJobRun_date])
     VALUES
           (@chLastRun) 
           
/* s02-Create TempDB Tables */
IF EXISTS 
                (SELECT * 
                FROM    tempdb.dbo.sysobjects 
                WHERE   id = OBJECT_ID(N'[tempdb].[dbo].[HoldforEachDB]')
                ) 
        DROP TABLE [tempdb].[dbo].[HoldforEachDB]
GO 

CREATE TABLE [tempdb].[dbo].[HoldforEachDB]
                (
                        [Server] NVARCHAR(128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL, 
                        [InstanceName] NVARCHAR(128) COLLATE SQL_Latin1_General_CP1_CI_AS  NULL, 
                        [DatabaseName] NVARCHAR(128) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL, 
                        [FileId]  smallint NOT NULL,
                        [GroupId] smallint NOT NULL, 
                        [Size]    real NOT NULL,
                        [MaxSize] real NOT NULL,
                        [Growth]  real NOT NULL,  
                        [FileStatus] [int] NOT NULL, 
                        [LogicalName] NVARCHAR(128) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL, 
                        [Filename] NVARCHAR(260) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL, 
                        [DatabaseStatus] NVARCHAR(128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL, 
                        [Updateability] NVARCHAR(128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL, 
                        [User_Access] NVARCHAR(128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL, 
                        [Recovery] NVARCHAR(128) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
                        [SpaceUsed(MB)] real ,
                        [UsageType] VARCHAR (6),
   [Owner] NVARCHAR(128) NULL,
   [CreateDate] datetime NULL,
   [CmptLevel] tinyint NULL,
                        [DateChecked] datetime                      
                ) 
        ON      [PRIMARY]
GO
IF OBJECT_ID('tempdb.dbo.ErrorLog') IS NOT NULL
    DROP TABLE tempdb.dbo.ErrorLog
GO

CREATE TABLE tempdb.dbo.ErrorLog(
   [Server] [nvarchar](128) NOT NULL,
   [dtMessage] [datetime] NULL,
   [SPID] [varchar](50) NULL,
   [vchMessage] [nvarchar](1024) NULL,
   [ID] [int] NULL
) ON [PRIMARY]
GO
IF EXISTS 
               (SELECT * 
                FROM    tempdb.dbo.sysobjects 
                WHERE   id = OBJECT_ID(N'[tempdb].[dbo].[HoldDiskSpace]')
                ) 
        DROP TABLE [tempdb].[dbo].[HoldDiskSpace]
GO 
CREATE TABLE [tempdb].[dbo].[HoldDiskSpace] (
             [Server] NVARCHAR(128),
             Drive CHAR(1) PRIMARY KEY,
             [Free(MB)] INT NULL,
             [Total(MB)] INT NULL,
             [Free(%)] tinyint NULL,
             [DateChecked] [datetime] NOT NULL CONSTRAINT [DF_HoldDiskSpace_Date Checked]  DEFAULT (GETDATE()),
)
GO
IF EXISTS (SELECT * 
           FROM    tempdb.dbo.sysobjects 
           WHERE   id = OBJECT_ID(N'[tempdb].[dbo].[Hold_XP_MSVER]')
                ) 
        DROP TABLE [tempdb].[dbo].[Hold_XP_MSVER]
GO 

CREATE TABLE [tempdb].[dbo].[Hold_XP_MSVER]
(
  IDX       INT NULL,
  C_NAME    VARCHAR(100) NULL,
  INT_VALUE FLOAT NULL,
  C_VALUE   VARCHAR(128) NULL) 
  
/* s04-Start Job - Report Errors from Package Execution */

EXEC msdb.dbo.sp_start_job N'DBA-SQL Overview - Report Table Refresh Errors'

/* s05-Start Job - Report Instances Recently Started */

EXEC msdb.dbo.sp_start_job N'DBA-SQL Overview - Report Instances Recently Started'




/* Reporting Job: DBA-SQL Overview - Report Table Refresh Errors */
-- Remember: Change ??@domain.com to yours or  your teams e-mail account.

SET nocount ON 
-- 
 DECLARE @Subject     VARCHAR (100)
 SET @Subject='SQL Server - SQL Overview Table Refresh Errors'

DECLARE @Count AS INT
SELECT @Count=COUNT(*) FROM SSIS_Errors
PRINT @Count

IF @Count > 0 
BEGIN

DECLARE @tableHTML  NVARCHAR(MAX) ;
SET @tableHTML =
    N'<table border="1">' +
    N'<tr>' +
    N'<th>Server</th>' +
    N'<th>TaskName</th>' +
    N'<th>ErrorCode</th>' +
    N'<th>ErrorDescription</th>' +
    N'</tr>' +
    CAST ( ( SELECT td=[server],''
      ,td=[TaskName],''
      ,td=[ErrorCode],''
      ,td=[ErrorDescription],''
  FROM [SSIS_Errors]
ORDER BY 1,2,3,4
      FOR XML PATH('tr'), TYPE 
    ) AS NVARCHAR(MAX) ) +
    N'</table>' ;

EXEC msdb.dbo.sp_send_dbmail 
    @profile_name = 'Default',
    @recipients = '??@domain.com',
    @subject = @Subject,
    @body = @tableHTML,
    @body_format = 'HTML' ;

END
 



/* Reporting Job: DBA-SQL Overview - Report Instances Recently Started */
-- Remember: Change ??@domain.com to yours or  your teams e-mail account.

SET nocount ON
--
DECLARE @dtLastRun datetime
SELECT @dtLastRun = LastJobRun_date from [rep].SQL_Overview_Last_Run_Date
SELECT @dtLastRun = ISNULL (@dtLastRun ,DATEADD(dd,-2,current_timestamp))
PRINT 'Last Run Date = ' + Convert(char(26),@dtLastRun)
-- 
 DECLARE @Subject     VARCHAR (100)
 SET @Subject='SQL Server - Instances Recently Started'

DECLARE @Count AS INT
SELECT @Count=COUNT(*) FROM [dbo].[SQL_Servers] 
 WHERE [InstanceLastStartDate] > @dtLastRun 
PRINT @Count

IF @Count > 0 
BEGIN

DECLARE @tableHTML  NVARCHAR(MAX) ;
SET @tableHTML =
        N'<table border="1">' +
    N'<tr>' +
    N'<th>Server</th>' +
    N'<th>InstanceLastStartDate</th>' +
    N'<th>ProductVersion</th>' +
    N'<th>WindowsVersion</th>' +
    N'<th>ProcessorCount</th>' +
    N'<th>PhysicalMemory</th>' +
    N'</tr>' +
    CAST ( ( 
SELECT td=[Server],''
      ,td=[InstanceLastStartDate],''
      ,td=[ProductVersion],''
      ,td=[WindowsVersion],''
      ,td=[ProcessorCount],''
      ,td=[PhysicalMemory],''
  FROM [dbo].[SQL_Servers]
WHERE  [InstanceLastStartDate] > @dtLastRun 


ORDER BY 1,2
      FOR XML PATH('tr'), TYPE 
    ) AS NVARCHAR(MAX) ) +
    N'</table>' ;

EXEC msdb.dbo.sp_send_dbmail 
    @profile_name = 'Default',
    @recipients = '??@domain.com',
    @subject = @Subject,
    @body = @tableHTML,
    @body_format = 'HTML' ;

END