-- This table will contain all the instances error logs
USE [SQL_Overview]
GO
CREATE TABLE [dbo].[ErrorLog](
       [Server] [nvarchar](128) NOT NULL,
       [dtMessage] [datetime] NULL,
       [SPID] [varchar](50) NULL,
       [vchMessage] [nvarchar](4000) NULL,
       [ID] [int] NULL
    ) ON [PRIMARY] 
GO
-- This table is used on each instances
IF OBJECT_ID('tempdb.dbo.ErrorLog') IS NOT NULL
DROP TABLE tempdb.dbo.ErrorLog
GO
CREATE TABLE tempdb.dbo.ErrorLog(
       [Server] [nvarchar](128) NOT NULL,
       [dtMessage] [datetime] NULL,
       [SPID] [varchar](50) NULL,
       [vchMessage] [nvarchar](4000) NULL,
       [ID] [int] NULL
    ) ON [PRIMARY] 
GO


-- This script is executed on each instance
-- It can be tested on a currently connected instance


-- Drop Temporary Tables
IF OBJECT_ID('tempdb..#Errors8') IS NOT NULL
    DROP TABLE #Errors8
IF OBJECT_ID('tempdb..#Errors9') IS NOT NULL
    DROP TABLE #Errors9
IF OBJECT_ID('tempdb..#ErrorLogs') IS NOT NULL
    DROP TABLE #ErrorLogs
IF OBJECT_ID('tempdb.dbo.ErrorLog') IS NOT NULL
    DROP TABLE tempdb.dbo.ErrorLog
GO
CREATE TABLE tempdb.dbo.ErrorLog(
       [Server] [nvarchar](128) NOT NULL,
       [dtMessage] [datetime] NULL,
       [SPID] [varchar](50) NULL,
       [vchMessage] [nvarchar](4000) NULL,
       [ID] [int] NULL
    ) ON [PRIMARY]
-- Set extract date for 2 days
DECLARE @ExtractDate datetime
    SET @ExtractDate = DATEADD(dd,-2,CURRENT_TIMESTAMP)
SELECT 'Extract Date = ' + CONVERT(CHAR(26),@ExtractDate)
-- SQL Server 2000 and 2005 each has different formats for reading the Error Log file
DECLARE @VersionId AS CHAR(1)
SELECT @VersionId = LEFT(CONVERT(VARCHAR(100),SERVERPROPERTY('ProductVersion')),1)

CREATE TABLE #ErrorLogs (intFileId INT
                , dtLastChangeDate DateTime NOT NULL
                , biLogFileSize bigint)
INSERT INTO #ErrorLogs 
    EXEC master.dbo.xp_enumerrorlogs
DECLARE @SQL AS VARCHAR(256)
-- Define Temp Table to contain error log messages
IF @VersionId = 8
    CREATE TABLE #Errors8 (vchMessage VARCHAR(255), ID INT)
ELSE
CREATE TABLE #Errors9 (LogDate datetime, Processinfo VARCHAR (10), vchMessage NVARCHAR(4000))
-- Processes Error Logs files modified since last Run Date
DECLARE ErrorLog_cursor CURSOR FOR
SELECT intFileId 
    FROM #ErrorLogs
    WHERE dtLastChangeDate > @ExtractDate
OPEN ErrorLog_cursor
DECLARE @intFileId INT
            FETCH NEXT 
    FROM ErrorLog_cursor INTO @intFileId
WHILE (@@FETCH_STATUS <> -1)
    BEGIN
    IF (@@FETCH_STATUS <> -2)
        BEGIN
        -- Load Error Log into temporary Table
        IF @intFileId = 0
            IF @VersionId = 8
            INSERT #Errors8 
            EXEC master.dbo.xp_readerrorlog
        ELSE
        INSERT #Errors9 
            EXEC master.dbo.xp_readerrorlog
        ELSE
        IF @VersionId = 8
            INSERT #Errors8 
            EXEC master.dbo.xp_readerrorlog @intFileId
        ELSE
        INSERT #Errors9 
            EXEC master.dbo.xp_readerrorlog @intFileId
        END
                FETCH NEXT 
        FROM ErrorLog_cursor INTO @intFileId
    END
            CLOSE ErrorLog_cursor
            DEALLOCATE ErrorLog_cursor
-- Extract all error log record for last two days
IF @VersionId = 8
    BEGIN
    INSERT INTO tempdb.dbo.ErrorLog
        ([Server]
        ,[dtMessage]
        ,[SPID]
        ,[vchMessage]
        ,[ID])
    SELECT @@SERVERNAME
          ,CASE ISDATE( LEFT(vchMessage,22))
                    WHEN 1 THEN LEFT(vchMessage,22)
           ELSE '1900-01-01'
           END
          ,NULL
          ,vchMessage, ID
        FROM #Errors8
    END
ELSE
    BEGIN
    INSERT INTO tempdb.dbo.ErrorLog
        ([Server]
        ,[dtMessage]
        ,[SPID]
        ,[vchMessage]
        ,[ID])
    SELECT @@SERVERNAME
           ,LogDate
           ,Processinfo
           ,vchMessage, NULL
        FROM #Errors9
        WHERE LogDate >= @ExtractDate
    END
DELETE 
    FROM tempdb.dbo.ErrorLog 
    WHERE [dtMessage] < @ExtractDate
SELECT * 
    FROM tempdb.dbo.ErrorLog
-- Drop Temporary Tables
IF OBJECT_ID('tempdb..#Errors8') IS NOT NULL
    DROP TABLE #Errors8
IF OBJECT_ID('tempdb..#Errors9') IS NOT NULL
    DROP TABLE #Errors9
IF OBJECT_ID('tempdb..#ErrorLogs') IS NOT NULL
    DROP TABLE #ErrorLogs 
GO


-- This query is used to retrieve errors logs that could be a potential problem
SELECT [Server] 
      ,[dtMessage] 
      ,[SPID] 
      ,[vchMessage] 
      ,[ID] 
  FROM [SQL_Overview].[dbo].[ErrorLog] 
WHERE ([vchMessage] LIKE '%error%' 
   OR  [vchMessage] LIKE '%fail%' 
   OR  [vchMessage] LIKE '%Warning%' 
   OR  [vchMessage] LIKE '%The SQL Server cannot obtain a LOCK resource at this time%' 
   OR  [vchMessage] LIKE '%Autogrow of file%in database%cancelled or timed out after%' 
   OR  [vchMessage] LIKE '% is full%' 
   OR  [vchMessage] LIKE '% blocking processes%' 
) 
AND [vchMessage] NOT LIKE '%\ERRORLOG%' 
AND [vchMessage] NOT LIKE '%Attempting to cycle errorlog%' 
AND [vchMessage] NOT LIKE '%Errorlog has been reinitialized.%'  
AND [vchMessage] NOT LIKE '%found 0 errors and repaired 0 errors.%' 
AND [vchMessage] NOT LIKE '%without errors%' 
AND [vchMessage] NOT LIKE '%This is an informational message%' 
AND [vchMessage] NOT LIKE '%WARNING:%Failed to reserve contiguous memory%' 
AND [vchMessage] NOT LIKE '%The error log has been reinitialized%' 
AND [vchMessage] NOT LIKE '%Setting database option ANSI_WARNINGS%' 
AND [vchMessage] NOT LIKE '%Error: 15457, Severity: 0, State: 1%' 
AND [vchMessage] <>  'Error: 18456, Severity: 14, State: 16.'  

