USE SQL_Overview
GO

-- Create table SSIS_ServerList
CREATE TABLE [dbo].[SSIS_ServerList](
    [Server] [varchar](128) NOT NULL,
    [Usage] [char](10) NULL, 
    [Skip_SQL_Overview] [bit] NULL,
 CONSTRAINT [PK_SSIS_ServerList] PRIMARY KEY CLUSTERED
(
    [Server] ASC
)
)
GO


-- Load table with server names
-- This will only work if XP_CMDSHELL is Enabled
USE SQL_Overview
GO
Create table #Server ( [Server] [varchar](128) )
Insert Into #Server  
    Exec xp_cmdshell 'sqlcmd /Lc' 
Insert Into SSIS_ServerList  ([Server])
    select [Server] from #Server where [Server] is not null
DROP Table #Server
GO
SELECT [Server] from SSIS_ServerList
GO


-- Create table Database_Status
USE [SQL_Overview]
GO
CREATE TABLE [dbo].[Database_Status](
    [Server] [nvarchar](128) NOT NULL,
    [InstanceName] [nvarchar](128) NULL,
    [DatabaseName] [nvarchar](128) NOT NULL,
    [DatabaseStatus] [nvarchar](128) NULL,
    [Updatability] [nvarchar](128) NULL,
    [User_Access] [nvarchar](128) NULL,
    [Recovery] [nvarchar](128) NULL
) ON [PRIMARY] 
GO


-- Create table SSIS_Errors
USE [SQL_Overview]
GO
CREATE TABLE [dbo].[SSIS_Errors](
       [Server] [varchar](128) NOT NULL,
       [TaskName] [varchar](128) NULL,
       [ErrorCode] [int] NULL,
       [ErrorDescription] [varchar](MAX) NULL
    ) ON [PRIMARY] 
