USE SQL_Overview
GO

CREATE TABLE [dbo].[Job_Activity](
   [Server] [nvarchar](128) NOT NULL,
   [session_id] [int] NOT NULL,
   [job_id] [uniqueidentifier] NOT NULL,
   [job_name] [sysname] NOT NULL,
   [run_requested_date] [datetime] NULL,
   [run_requested_source] [sysname] NULL,
   [queued_date] [datetime] NULL,
   [start_execution_date] [datetime] NULL,
   [last_executed_step_id] [int] NULL,
   [last_executed_step_date] [datetime] NULL,
   [stop_execution_date] [datetime] NULL,
   [next_scheduled_run_date] [datetime] NULL,
   [job_history_id] [int] NULL,
   [message] [nvarchar](1024) NULL,
   [run_status] [int] NULL,
   [operator_id_emailed] [int] NULL,
   [operator_id_netsent] [int] NULL,
   [operator_id_paged] [int] NULL,
   [Row_inserted_date] [datetime] NOT NULL
) ON [PRIMARY]
GO
ALTER TABLE [dbo].[Job_Activity] 
  ADD  CONSTRAINT [DF_Job_Activity_Server]  DEFAULT (@@servername) 
       FOR [Server]
GO
ALTER TABLE [dbo].[Job_Activity] 
  ADD  CONSTRAINT [DF_Job_Activity_Package_run_date]  DEFAULT (GETDATE()) 
       FOR [Row_inserted_date]
GO

CREATE TABLE [rep].[Long_Running_Jobs](
   [Server] [nvarchar](128) NOT NULL,
   [Job_Name] [nvarchar](128) NOT NULL,
   [Alert_RunTime_Minutes] [bigint] NULL,
   [Last_Reported_Job_Duration] [nvarchar](50) NULL,
   [Last_Reported_Date] [datetime] NOT NULL,
 CONSTRAINT [PK_Long_Running_Jobs_Thresholds] PRIMARY KEY CLUSTERED 
(
   [Server] ASC,
   [Job_Name] ASC
)
) ON [PRIMARY]
GO
ALTER TABLE [rep].[Long_Running_Jobs] 
      ADD  CONSTRAINT [DF_Long_Running_Jobs_Last_Report_date]  DEFAULT (GETDATE()) 
           FOR [Last_Reported_Date]
GO
/****** Object:  Table [dbo].[SSIS_Errors_JobActivity]    Script Date: 11/16/2009 13:15:03 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO
CREATE TABLE [dbo].[SSIS_Errors_JobActivity](
	[Server] [varchar](128) NOT NULL,
	[TaskName] [varchar](128) NULL,
	[ErrorCode] [int] NULL,
	[ErrorDescription] [varchar](max) NULL
) ON [PRIMARY]

GO
SET ANSI_PADDING OFF