USE [tempdb]
GO

IF EXISTS 
               (SELECT * 
                FROM    tempdb.dbo.sysobjects 
                WHERE   id = OBJECT_ID(N'[tempdb].[dbo].[Job_Info]')
                ) 
        DROP TABLE [tempdb].[dbo].[Job_Info]

GO

CREATE TABLE [tempdb].[dbo].[Job_Info] (
	[job_id] [uniqueidentifier] NULL ,
	[originating_server] [nvarchar] (30)  NULL ,
	[name] [nvarchar] (128)  NULL ,
	[enabled] [tinyint] NULL ,
	[description] [nvarchar] (512)  NULL ,
	[start_step_id] [int] NULL ,
	[category] [sysname] NULL ,
	[owner] [nvarchar] (128)  NULL ,
	[notify_level_eventlog] [int] NULL ,
	[notify_level_email] [int] NULL ,
	[notify_level_netsend] [int] NULL ,
	[notify_level_page] [int] NULL ,
	[notify_email_operator] [sysname] NULL ,
	[notify_netsend_operator] [sysname] NULL ,
	[notify_page_operator] [sysname] NULL ,
	[delete_level] [int] NULL ,
	[date_created] [datetime] NULL ,
	[date_modified] [datetime] NULL ,
	[version_number] [int] NULL ,
	[last_run_date] [int] NULL ,
	[last_run_time] [int] NULL ,
	[last_run_outcome] [int] NULL ,
	[next_run_date] [int] NULL ,
	[next_run_time] [int] NULL ,
	[next_run_schedule_id] [int] NULL ,
	[current_execution_status] [int] NULL ,
	[current_execution_step] [sysname] NULL ,
	[current_retry_attempt] [int] NULL ,
	[has_step] [int] NULL ,
	[has_schedule] [int] NULL ,
	[has_target] [int] NULL ,
	[type] [int] NULL ,
	[last_run_duration] [int] NULL ,
	[last_outcome_message] [nvarchar] (1024)  NULL ,
	[Package_run_date] [datetime] NOT NULL CONSTRAINT [DF_Package_run_date]  DEFAULT (getdate()),
  ) ON [PRIMARY]
GO