USE tempdb
GO
IF EXISTS 
               (SELECT * 
                FROM    tempdb.dbo.sysobjects 
                WHERE   id = OBJECT_ID(N'[tempdb].[dbo].[Job_Activity]')
                ) 
        DROP TABLE [tempdb].[dbo].[Job_Activity]
GO
CREATE TABLE [tempdb].[dbo].[Job_Activity](
	[Server] [nvarchar](128) NOT NULL CONSTRAINT [DF_Job_Activity_Server]  DEFAULT (@@servername),
	[session_id] [int] NOT NULL,
	[job_id] [uniqueidentifier] NOT NULL,
	[job_name] [sysname] NOT NULL,
	[run_requested_date] [datetime] NULL,
	[run_requested_source] [sysname] NULL,
	[queued_date] [datetime] NULL,
	[start_execution_date] [datetime] NULL,
	[last_executed_step_id] [int] NULL,
	[last_executed_step_date] [datetime] NULL,
	[stop_execution_date] [datetime] NULL,
	[next_scheduled_run_date] [datetime] NULL,
	[job_history_id] [int] NULL,
	[message] [nvarchar](1024) NULL,
	[run_status] [int] NULL,
	[operator_id_emailed] [int] NULL,
	[operator_id_netsent] [int] NULL,
	[operator_id_paged] [int] NULL,
	[Row_inserted_date] [datetime] NOT NULL CONSTRAINT [DF_Row_inserted_date]  DEFAULT (getdate())
) ON [PRIMARY]
GO