USE master
GO
IF DB_ID('Persons2012') IS NOT NULL 
    DROP DATABASE Persons2012;
GO

-- Clear backup history
EXEC msdb.dbo.sp_delete_database_backuphistory @database_name = N'Persons2012'
GO

CREATE DATABASE Persons2012 ON PRIMARY 
 (   NAME = N'Persons2012'
   , FILENAME = N'C:\SQLData\Persons2012.mdf'
   , SIZE = 199680KB
   , FILEGROWTH = 16384KB
 ) LOG ON
 (   NAME = N'Persons2012_log'
   , FILENAME = N'D:\SQLData\Persons2012_log.ldf'
   , SIZE = 2048KB
   , FILEGROWTH = 2048KB
 )
GO

ALTER DATABASE Persons2012 SET RECOVERY FULL;

USE master
GO
BACKUP DATABASE Persons2012
TO DISK ='D:\SQL2012Backups\Persons_full.bak'
WITH INIT;
GO

USE Persons2012
GO
IF EXISTS ( SELECT  *
            FROM    sys.objects
            WHERE   object_id = OBJECT_ID(N'dbo.PersonsAW2012')
                    AND type = N'U' ) 
    DROP TABLE dbo.PersonsAW2012;
GO

CREATE TABLE dbo.PersonsAW2012
    (
      PersonID INT NOT NULL
                   IDENTITY ,
      FName VARCHAR(20) NOT NULL ,
      LName VARCHAR(30) NOT NULL ,
      Email VARCHAR(7000) NOT NULL
    );
GO
INSERT  INTO dbo.PersonsAW2012
        ( FName ,
          LName ,
          Email
        )
        SELECT TOP 1000000
                LEFT(aw1.FirstName, 20) ,
                LEFT(aw1.LastName, 30) ,
                aw1.FirstName + '.' + aw1.LastName + '@adventure-works.com'
        FROM    AdventureWorks2012.Person.Person aw1
                CROSS JOIN AdventureWorks2012.Person.Person aw2
GO

