#Load SMO assemblies
$MS='Microsoft.SQLServer'
@('.SMO') |
     foreach-object {
        if ([System.Reflection.Assembly]::LoadWithPartialName("$MS$_") -eq $null) 
           {"missing SMO component $MS$_"}
     }
set-psdebug -strict
$ErrorActionPreference = "stop" # 

$My="$MS.Management.Smo" #
@("YourServerPath\InstanceName","MySecondServer") |
   foreach-object {new-object ("$My.Server") $_ } | # create an SMO server object
    Where-Object {$_.ServerType -ne $null} | # did you positively get the server?
      Foreach-object {$_.Databases } | #for every server successfully reached 
         Foreach-object { #at this point you have reached the database
         $Db=$_
         $_.ExecuteWithResults(dbcc loginfo).Tables[0] | #make the DBCC query
           Measure-Object -minimum -maximum -average -sum FileSize |
                                                  #group the results by filesize
             Select-object @{Name="Server"; Expression={$Db.parent.name}}, 
                           @{Name="Database"; Expression={$Db.name}},  
                           @{Name="No.VLFs"; Expression={$_.Count}}, 
                           @{Name="MaxVLFSize(mb)"; Expression={"{0:n2}" f
                                                            ($_.Maximum/1MB)}}, 
                           @{Name="MinVLFSize(mb)"; Expression={"{0:n2}" f
                                                            ($_.Minimum/1MB)}}, 
                           @{Name="AverageVLF(mb)"; Expression={"{0:n2}" f
                                                            ($_.Average/1MB)}},
                           @{Name="SumVLF(mb)"; Expression={"{0:n2}" f
                                                            ($_.Sum/1MB)}}
                           } | Format-Table * -AutoSize
