#Load SMO assemblies
$MS='Microsoft.SQLServer'
@('.SMO') |
     foreach-object {
        if ([System.Reflection.Assembly]::LoadWithPartialName("$MS$_") -eq $null) 
           {"missing SMO component $MS$_"}
     }
set-psdebug -strict
$ErrorActionPreference = "stop" # you can opt to stagger on, bleeding
                                # if an error occurs

$My="$MS.Management.Smo" 
@("YourServerPath\InstanceName","MySecondServer") |
   foreach-object {new-object ("$My.Server") $_ } | # create an SMO server object
    Where-Object {$_.ServerType -ne $null} | # did you positively get the server?
      Foreach-object {$_.Databases } | #for every server successfully reached 
        Where-Object {$_.IsSystemObject -ne $true} | #not the system objects
          foreach-object{$_.Logfiles} |
           Select-object @{Name="Server"; Expression={$_.parent.parent.name}}, 
                         @{Name="Database"; Expression={$_.parent.name}},  
                         Name, Filename, 
                         @{Name="Growth"; Expression={"$($_.Growth)
                                                            $($_.GrowthType)"}},  
                         @{Name="size(mb)"; Expression={"{0:n2}" f
                                                          ($_.size/1MB)}}, 
                         @{Name="MaxSize(mb)"; Expression={"{0:n2}" f
                                                            ($_.MaxSize/1MB)}}, 
                         NumberOfDiskReads,NumberOfDiskWrites,
                         BytesReadFromDisk,BytesWrittenToDisk |
               Out-GridView 
