/*Listing 9.1: Updating the PersonsAW2012 table*/
USE Persons2012
GO
DECLARE @cnt INT;

SET @cnt = 1;
-- may take several minutes; reduce the number of loops, if required
WHILE @cnt < 6 
    BEGIN;
        SET @cnt = @cnt + 1;
        UPDATE  dbo.PersonsAW2012
        SET     Email = LEFT(Email + Email, 7000)
    END;
/*Listing 9.2: Log size and space used*/
SELECT  DB_NAME(database_id) AS DatabaseName ,
        database_id ,
        CAST(( total_log_size_in_bytes / 1048576.0 ) AS DECIMAL(10, 1)) AS TotalLogSizeMB ,
        CAST(( used_log_space_in_bytes / 1048576.0 ) AS DECIMAL(10, 1)) AS LogSpaceUsedMB ,
        CAST(used_log_space_in_percent AS DECIMAL(10, 1)) AS LogSpaceUsedPercent
FROM    sys.dm_db_log_space_usage;

/*Listing 9.3: Capturing baseline disk I/O statistics from sys.dm_io_virtual_file_stats in a temporary table*/
SELECT  DB_NAME(mf.database_id) AS databaseName ,
        mf.physical_name ,
        divfs.num_of_reads ,
        divfs.num_of_bytes_read ,
        divfs.io_stall_read_ms ,
        divfs.num_of_writes ,
        divfs.num_of_bytes_written ,
        divfs.io_stall_write_ms ,
        divfs.io_stall ,
        size_on_disk_bytes ,
        GETDATE() AS baselineDate
INTO    #baseline
FROM    sys.dm_io_virtual_file_stats(NULL, NULL) AS divfs
        JOIN sys.master_files AS mf ON mf.database_id = divfs.database_id
                                       AND mf.file_id = divfs.file_id

/*Listing 9.4: Querying the #baseline temporary table*/
SELECT  physical_name ,
        num_of_reads ,
        num_of_bytes_read ,
        io_stall_read_ms ,
        num_of_writes ,
        num_of_bytes_written ,
        io_stall_write_ms
FROM    #baseline
WHERE   databaseName = 'Persons2012'

/*Listing 9.5: Capturing disk I/O statistics, since the baseline measurement*/
WITH    currentLine
          AS ( SELECT  DB_NAME(mf.database_id) AS databaseName ,
                        mf.physical_name ,
                        num_of_reads ,
                        num_of_bytes_read ,
                        io_stall_read_ms ,
                        num_of_writes ,
                        num_of_bytes_written ,
                        io_stall_write_ms ,
                        io_stall ,
                        size_on_disk_bytes ,
                        GETDATE() AS currentlineDate
               FROM     sys.dm_io_virtual_file_stats(NULL, NULL) AS divfs
                        JOIN sys.master_files AS mf ON mf.database_id = divfs.database_id
                                                       AND mf.file_id = divfs.file_id
             )
    SELECT  currentLine.databaseName ,
            LEFT(currentLine.physical_name, 1) AS drive ,
            currentLine.physical_name ,
            DATEDIFF(millisecond, baseLineDate, currentLineDate) AS elapsed_ms ,
            currentLine.io_stall - #baseline.io_stall AS io_stall_ms ,
            currentLine.io_stall_read_ms - #baseline.io_stall_read_ms AS io_stall_read_ms ,
            currentLine.io_stall_write_ms - #baseline.io_stall_write_ms AS io_stall_write_ms ,
            currentLine.num_of_reads - #baseline.num_of_reads AS num_of_reads ,
            currentLine.num_of_bytes_read - #baseline.num_of_bytes_read AS num_of_bytes_read ,
            currentLine.num_of_writes - #baseline.num_of_writes AS num_of_writes ,
            currentLine.num_of_bytes_written - #baseline.num_of_bytes_written AS num_of_bytes_written
    FROM    currentLine
            INNER JOIN #baseline ON #baseLine.databaseName = currentLine.databaseName
                                    AND #baseLine.physical_name = currentLine.physical_name
    WHERE   #baseline.databaseName = 'Persons2012';
    
DECLARE @object_name SYSNAME
SET @object_name = CASE WHEN @@servicename = 'MSSQLSERVER' THEN 'SQLServer'
                        ELSE 'MSSQL$' + @@serviceName
                   END + ':Databases'

/*Listing 9.6: Capturing log growth and shrink events*/
DECLARE @PERF_COUNTER_LARGE_RAWCOUNT INT 
SELECT  @PERF_COUNTER_LARGE_RAWCOUNT = 65792

SELECT  object_name ,
        counter_name ,
        instance_name ,
        cntr_value
FROM    sys.dm_os_performance_counters
WHERE   cntr_type = @PERF_COUNTER_LARGE_RAWCOUNT
        AND object_name = @object_name
        AND counter_name IN ( 'Log Growths', 'Log Shrinks' )
        AND cntr_value > 0
ORDER BY object_name ,
        counter_name ,
        instance_name

