/*Listing 8.1: Create the Persons database with two log files*/
USE master
GO
IF DB_ID('Persons') IS NOT NULL 
    DROP DATABASE Persons;
GO

CREATE DATABASE [Persons] ON PRIMARY 
 (   NAME = N'Persons'
   , FILENAME = N'D:\SQLData\Persons.mdf'
   , SIZE = 199680KB
   , FILEGROWTH = 16384KB
 ) LOG ON
 (   NAME = N'Persons_log'
   , FILENAME = N'D:\SQLData\Persons_log.ldf'
   , SIZE = 2048KB
   , FILEGROWTH = 16384KB
 ),
 (   NAME = N'Persons_log2'
   , FILENAME = N'C:\SQLData\Persons_log2.ldf'
   , SIZE = 2048KB
   , FILEGROWTH = 16384KB
 )
GO

ALTER DATABASE Persons SET RECOVERY FULL;

USE master
go
BACKUP DATABASE Persons
TO DISK ='D:\SQLBackups\Persons_full.bak'
WITH INIT;
GO

/*Listing 8.2: Create a sample Persons table.*/
USE Persons
GO
IF EXISTS ( SELECT  *
            FROM    sys.objects
            WHERE   object_id = OBJECT_ID(N'dbo.Persons')
                    AND type = N'U' ) 
    DROP TABLE dbo.Persons;
go

CREATE TABLE dbo.Persons
    (
      PersonID INT NOT NULL
                   IDENTITY ,
      FName VARCHAR(20) NOT NULL ,
      LName VARCHAR(30) NOT NULL ,
      Email VARCHAR(7000) NOT NULL
    );
GO

/*Listing 8.3: Add 15000 rows to the Persons table and run DBCC LOGINFO.*/
INSERT  INTO dbo.Persons
        ( FName ,
          LName ,
          Email
        )
        SELECT TOP 15000
                LEFT(aw1.FirstName, 20) ,
                LEFT(aw1.LastName, 30) ,
                aw1.EmailAddress
        FROM    AdventureWorks2005.Person.Contact aw1
                CROSS JOIN AdventureWorks2005.Person.Contact aw2;
GO

USE Persons
GO
DBCC LOGINFO;

/*Listing 8.3b: Alternative code to add 15000 rows to the Persons table */
INSERT  INTO dbo.Persons
        ( FName ,
          LName ,
          Email
        )
        SELECT TOP 15000
                LEFT(aw1.FirstName, 20) ,
                LEFT(aw1.LastName, 30) ,
                aw1.FirstName + '.' + aw1.LastName + '@adventure-works.com'
        FROM    AdventureWorks2008.Person.Person aw1
                CROSS JOIN AdventureWorks2008.Person.Person aw2
GO