USE master
GO
IF DB_ID('Persons') IS NOT NULL 
    DROP DATABASE Persons;
GO

CREATE DATABASE [Persons] ON PRIMARY 
 (   NAME = N'Persons'
   , FILENAME = N'C:\SQLData\Persons.mdf'
   , SIZE = 2097152KB
   , FILEGROWTH = 1048576KB
 )
 LOG ON
 (   NAME = N'Persons_log'
   , FILENAME = N'D:\SQLData\Persons_log.ldf'
   , SIZE = 2097152KB
   , FILEGROWTH = 2097152KB
 )
GO
USE Persons
GO
DBCC LOGINFO;
-- 16 VLFs

USE master
GO
ALTER DATABASE Persons MODIFY FILE ( NAME = N'Persons_log', SIZE = 4194304KB )
GO
-- 32 VLFs

ALTER DATABASE Persons MODIFY FILE ( NAME = N'Persons_log', SIZE = 6291456KB )
GO
-- 48 VLFs

ALTER DATABASE Persons MODIFY FILE ( NAME = N'Persons_log', SIZE = 8388608KB )
GO
-- 64 VLFs

ALTER DATABASE Persons SET RECOVERY FULL;

USE master
go
BACKUP DATABASE Persons
TO DISK ='D:\SQLBackups\Persons_full.bak'
WITH INIT;
GO

USE Persons
GO
IF EXISTS ( SELECT  *
            FROM    sys.objects
            WHERE   object_id = OBJECT_ID(N'dbo.Persons')
                    AND type = N'U' ) 
    DROP TABLE dbo.Persons;
go

CREATE TABLE dbo.Persons
    (
      PersonID INT NOT NULL
                   IDENTITY ,
      FName VARCHAR(20) NOT NULL ,
      LName VARCHAR(30) NOT NULL ,
      Email VARCHAR(7000) NOT NULL
    );
GO

INSERT  INTO dbo.Persons
        ( FName ,
          LName ,
          Email
        )
        SELECT TOP 1000000
          LEFT(aw1.FirstName, 20) ,
                LEFT(aw1.LastName, 30) ,
                aw1.EmailAddress
        FROM    AdventureWorks2005.Person.Contact aw1
        CROSS JOIN AdventureWorks2005.Person.Contact aw2;
GO
/*
INSERT  INTO dbo.Persons
        ( FName ,
          LName ,
          Email
        )
        SELECT TOP 15000
                LEFT(aw1.FirstName, 20) ,
                LEFT(aw1.LastName, 30) ,
                aw1.FirstName + '.' + aw1.LastName + '@adventure-works.com'
        FROM    AdventureWorks2008.Person.Person aw1
                CROSS JOIN AdventureWorks2008.Person.Person aw2
GO
*/
DBCC SQLPERF(LOGSPACE) ;
--8192 MB, 2.3% used
USE Persons
GO
DBCC LOGINFO;
-- 64 VLFs

/*Disable Automatic checkpoints*/
DBCC TRACEON( 3505 )
--DBCC TRACEOFF (3505)

/* this took 5 mins*/
BEGIN TRANSACTION
DECLARE @cnt INT;

SET @cnt = 1;

WHILE @cnt < 6 
    BEGIN;
        SET @cnt = @cnt + 1;
        UPDATE  dbo.Persons
        SET     Email = LEFT(Email + Email, 7000)
    END;

DBCC SQLPERF(LOGSPACE) ;
-- 12288 MB, 87.2% used
USE Persons
GO
DBCC LOGINFO;
-- 96 VLFs

/*Commit and immediately Shut down*/    
COMMIT TRANSACTION;
SHUTDOWN WITH NOWAIT

USE Persons
Go

EXEC sys.xp_readerrorlog 0, 1, 'Persons'

/*
2012-10-03 11:54:21.410  Starting up database 'Persons'.
2012-10-03 11:54:21.890  Recovery of database 'Persons' (6) is 0% complete (approximately 108 seconds remain).
2012-10-03 11:54:30.690  1 transactions rolled forward in database 'Persons' (6).
2012-10-03 11:54:30.710  Recovery completed for database Persons (database ID 6) in 3 second(s)
                         (analysis 2177 ms, redo 1058 ms, undo 10 ms.)
*/
