USE master
GO
IF DB_ID('Persons') IS NOT NULL 
    DROP DATABASE Persons;
GO

CREATE DATABASE [Persons] ON PRIMARY 
 (   NAME = N'Persons'
   , FILENAME = N'C:\SQLData\Persons.mdf'
   , SIZE = 2097152KB
   , FILEGROWTH = 1048576KB
 )
 LOG ON
 (   NAME = N'Persons_log'
   , FILENAME = N'D:\SQLData\Persons_log.ldf'
   , SIZE = 2097152KB
   , FILEGROWTH = 2097152KB
 )
GO


DBCC SQLPERF(LOGSPACE) ;
-- 2048 MB, 0% used
USE Persons
GO
DBCC LOGINFO;
-- 16 VLFs


USE master
GO
ALTER DATABASE Persons]MODIFY FILE ( NAME = N'Persons_log', SIZE = 4194304KB )
GO

USE Persons
GO
DBCC LOGINFO;
-- 32 VLFs

USE [master]
GO
ALTER DATABASE Persons MODIFY FILE ( NAME = N'Persons_log', SIZE = 6291456KB )
GO

USE Persons
GO
DBCC LOGINFO;
-- 48 VLFs

USE [master]
GO
ALTER DATABASE Persons MODIFY FILE ( NAME = N'Persons_log', SIZE = 8388608KB )
GO
-- 64 VLFs

ALTER DATABASE Persons SET RECOVERY FULL;

USE master
go
BACKUP DATABASE Persons
TO DISK ='D:\SQLBackups\Persons_full.bak'
WITH INIT;
GO


USE Persons
GO
IF EXISTS ( SELECT  *
            FROM    sys.objects
            WHERE   object_id = OBJECT_ID(N'dbo.Persons')
                    AND type = N'U' ) 
    DROP TABLE dbo.Persons;
go

CREATE TABLE dbo.Persons
    (
      PersonID INT NOT NULL
                   IDENTITY ,
      FName VARCHAR(20) NOT NULL ,
      LName VARCHAR(30) NOT NULL ,
      Email VARCHAR(7000) NOT NULL
    );
GO

INSERT  INTO dbo.Persons
        ( FName ,
          LName ,
          Email
        )
        SELECT TOP 1000000
          LEFT(aw1.FirstName, 20) ,
                LEFT(aw1.LastName, 30) ,
                aw1.EmailAddress
        FROM    AdventureWorks2005.Person.Contact aw1
        CROSS JOIN AdventureWorks2005.Person.Contact aw2;
GO
/*
INSERT  INTO dbo.Persons
        ( FName ,
          LName ,
          Email
        )
        SELECT TOP 1000000
                LEFT(aw1.FirstName, 20) ,
                LEFT(aw1.LastName, 30) ,
                aw1.FirstName + '.' + aw1.LastName + '@adventure-works.com'
        FROM    AdventureWorks2008.Person.Person aw1
                CROSS JOIN AdventureWorks2008.Person.Person aw2
GO
*/
DBCC SQLPERF(LOGSPACE) ;
--8192 MB, 2% used
USE Persons
GO
DBCC LOGINFO;
-- 64 VLFs

/*this took only 3.5 mins*/
DECLARE @cnt INT;

SET @cnt = 1;

WHILE @cnt < 6 
    BEGIN;
        SET @cnt = @cnt + 1;
        UPDATE  dbo.Persons
        SET     Email = LEFT(Email + Email, 7000)
    END;

DBCC SQLPERF(LOGSPACE) ;
--  8192 MB, 63.6% used
USE Persons
GO
DBCC LOGINFO;
-- 64 VLFs

USE master
GO
BACKUP LOG Persons
TO DISK ='D:\SQLBackups\Persons_log.trn'
WITH INIT;

/*Processed 666505 pages for database 'Persons', file 'Persons_log' on file 1.
BACKUP LOG successfully processed 666505 pages in 105.706 seconds (49.259 MB/sec).
*/