USE master
GO
IF DB_ID('Persons') IS NOT NULL 
    DROP DATABASE PersonsLots;
GO
CREATE DATABASE Personslots ON PRIMARY 
 (   NAME = N'PersonsLots'
   , FILENAME = N'C:\SQLData\Persons_lots.mdf'
   , SIZE = 199680KB
   , FILEGROWTH = 16384KB
)
LOG ON
(   NAME = N'PersonsLots_log'
   , FILENAME = N'D:\SQLData\Persons_lots.ldf'
   , SIZE = 2048KB 
   , FILEGROWTH = 2048KB
)
GO


DECLARE @LogGrowth INT = 0;
DECLARE @sSQL NVARCHAR(4000)
WHILE @LogGrowth < 4096

BEGIN
      
      SET @sSQL = 'ALTER DATABASE Personslots MODIFY FILE (NAME = PersonsLots_log, SIZE = ' + CAST(4096+2048*@LogGrowth AS VARCHAR(10)) +  'KB );'
      EXEC(@sSQL);
      SET @LogGrowth = @LogGrowth + 1;
END

ALTER DATABASE PersonsLots SET RECOVERY FULL;

USE master
go
BACKUP DATABASE PersonsLots
TO DISK ='D:\SQLBackups\PersonsLots_full.bak'
WITH INIT;
GO

USE PersonsLots
go
DBCC LOGINFO
--16388 VLFs

DBCC SQLPERF (LOGSPACE);
-- 8194 MB, 6.3% full


USE PersonsLots
GO
IF EXISTS ( SELECT  *
            FROM    sys.objects
            WHERE   object_id = OBJECT_ID(N'dbo.Persons')
                    AND type = N'U' ) 
    DROP TABLE dbo.Persons;
go

CREATE TABLE dbo.Persons
    (
      PersonID INT NOT NULL
                   IDENTITY ,
      FName VARCHAR(20) NOT NULL ,
      LName VARCHAR(30) NOT NULL ,
      Email VARCHAR(7000) NOT NULL
    );
GO

INSERT  INTO dbo.Persons
        ( FName ,
          LName ,
          Email
        )
        SELECT TOP 1000000
          LEFT(aw1.FirstName, 20) ,
                LEFT(aw1.LastName, 30) ,
                aw1.EmailAddress
        FROM    AdventureWorks2005.Person.Contact aw1
        CROSS JOIN AdventureWorks2005.Person.Contact aw2;
GO
/*
INSERT  INTO dbo.Persons
        ( FName ,
          LName ,
          Email
        )
        SELECT TOP 1000000
                LEFT(aw1.FirstName, 20) ,
                LEFT(aw1.LastName, 30) ,
                aw1.FirstName + '.' + aw1.LastName + '@adventure-works.com'
        FROM    AdventureWorks2008.Person.Person aw1
                CROSS JOIN AdventureWorks2008.Person.Person aw2
GO
*/
DBCC SQLPERF(LOGSPACE) ;
--8192 MB, 8.4% used
USE PersonsLots
GO
DBCC LOGINFO;
-- 16388 VLFs

BEGIN TRANSACTION
DECLARE @cnt INT;

SET @cnt = 1;

WHILE @cnt < 6 
    BEGIN;
        SET @cnt = @cnt + 1;
        UPDATE  dbo.Persons
        SET     Email = LEFT(Email + Email, 7000)
       -- WHERE   PersonID = CAST(RAND() * 10000 AS INT);
    END;

DBCC SQLPERF(LOGSPACE) ;
--11170 MB, 99.9% used
DBCC LOGINFO;
-- 22340 VLFs

/*FORCE CHECKPOINT*/
CHECKPOINT;

/*after shutdown form other session*/
USE PersonsLots
Go

EXEC sys.xp_readerrorlog 0, 1, 'PersonsLots'

/*
2012-10-03 12:51:35.360  Starting up database 'Personslots'.
2012-10-03 12:51:46.920  Recovery of database 'Personslots' (17) is 0% complete (approximately 10863 seconds remain).
2012-10-03 12:57:12.680  1 transactions rolled back in database 'Personslots' (17).
2012-10-03 12:57:14.680  Recovery completed for database Personslots (database ID 17) in 326 second(s)
                         (analysis 30 ms, redo 78083 ms, undo 246689 ms.)
*/